# Rozdział 6. - Laboratorium - Przykładowe rozwiązanie

Jeśli podczas lektury rozdziału 6. uruchamiałeś dużo kontenerów, to możesz zacząć od niewielkich porządków:

> Poniższe polecenie usunie **WSZYSTKIE** kontenery!

```
docker container rm -f $(docker container ls -aq)
```

Teraz uruchom kontener używając do tego obrazu aplikacji listy zadań przygotowanego na potrzeby tego laboratorium:

```
docker container run -d -p 8015:80 diamol/ch06-lab
```

Wyświetl w przeglądarce stronę *http://localhost:8015/list* - powinna ona wyglądać jak na poniższym rysunku:

![Sample to-do list with some important tasks](./todo-list-v3.png)

> Przedstawia on zestaw zadań, które każdy powinien wykonać! :)

A teraz utwórz wolumin, który posłuży do przechowania pliku bazy danych:

```
docker volume create ch06-lab
```

Możesz utworzyć plik konfiguracyjny, który określi inną ścieżkę do pliku bazy danych i tę ścieżkę można podać jako domontowanie.

Mój plik [config.json](./solution/config.json) konfiguruje aplikację w taki sposób, by plik bazy danych był zapisywany w katalogu `/new-data`.

Podsumowując, uruchomisz kontener, który będzie używał:

- domontowania przeznaczonego tylko do odczytu, używanego do wyczytania do kontenera pliku konfiguracyjnego;
- domonotowanego woluminu przeznaczonego do odczytu i zapisu, na którym będzie przechowywany plik bazy danych.

Zestaw ścieżek w systemie Windows wygląda w następujący sposób:

```
$configSource="$(pwd)/solution".ToLower()
$configTarget='c:\app\config'
$dataTarget='c:\new-data'
```

A w systemie Linux:

```
configSource="$(pwd)/solution"
configTarget='/app/config'
dataTarget='/new-data'
```

Teraz możesz już uruchomić kontener:

```
docker container run -d -p 8016:80 --mount type=bind,source=$configSource,target=$configTarget,readonly --volume ch06-lab:$dataTarget diamol/ch06-lab
```

I wyświetlić aplikację w przeglądarce: *http://localhost:8016/list*

> Zobaczysz pustą listę zadań, którą do woli będziesz mógł wypełniać.