"""
Provides English descriptions for operations as they happen.

Used for Table 6-2 in the book.
"""
class BinaryNode:
    """
    Node structure to use in a binary tree.

    Attributes
    ----------
        left  - left child (or None)
        right - right child (or None)
        value - value stored by Node
    """
    def __init__(self, val):
        self.value = val
        self.left  = None
        self.right = None

class SpeakingBinaryTree:
    """
    A Binary tree contains the root node, and methods to manipulate the tree.
    """
    def __init__(self):
        self.root = None

    def insert(self, val):
        """Insert value into Binary Tree."""
        (self.root,explanation) = self._insert(self.root, val, 'Gdy wstawiasz `{}`, '.format(val))
        return explanation

    def _insert(self, node, val, sofar):
        """Inserts a new BinaryNode to the tree containing this value."""
        if node is None:
            return (BinaryNode(val), '{}utwórz nowe poddrzewo z korzeniem `{}`.'.format(sofar, val))

        if val <= node.value:
            sofar += '`{1}` jest mniejsze lub równa względem `{0}`, dlatego należy wstawić `{1}` w lewym poddrzewie elementu `{0}`'.format(node.value, val)
            if node.left is None:
                sofar += ', jednak lewe drzewo nie istnieje, dlatego '
            else:
                sofar += ' z korzeniem `{}`. Teraz '.format(node.left.value)
            (node.left, expl) = self._insert(node.left, val, sofar)
            return (node, expl)

        sofar += '`{1}` jest większe niż `{0}`, dlatego należy wstawić `{1}` w prawym poddrzewie elementu `{0}`'.format(node.value, val)
        if node.right is None:
            sofar += ', jednak prawe poddrzewo nie istnieje, dlatego '
        else:
            sofar += ' z korzeniem `{}`. Teraz '.format(node.right.value)
        (node.right, expl) = self._insert(node.right, val, sofar)
        return (node, expl)
