
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Definicja pinów ultradźwiękowych
const int echo = 9, Trig = 10;
long duration, cm;

/////////////////////////////////////////////////////////////////////////////////////////
//Zmienne aktualizacji czasu

unsigned long LastUpdateMicrosecs = 0;		
unsigned long LastUpdateMillisecs = 0;
unsigned long CurrentMicrosecs = 0;
unsigned long MicrosecsSinceLastUpdate = 0;
float SecondsSinceLastUpdate = 0;


void setup()
{
  
  //uruchomienie portu szeregowego z prędkością transmisji 115200
  Serial.begin(115200);  
  SetupUltrasonic();  
    
  
  
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Ustawienie funkcji UltrasonicsSensor() function
void SetupUltrasonic()
{
 pinMode(Trig, OUTPUT);
 pinMode(echo, INPUT); 
  
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//GŁÓWNA PĘTLA



void loop()
{

    Update_Ultra_Sonic();
    delay(200);
 
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Aktualizacja sensorów ultradźwiękowych poprzez port szeregowy

void Update_Ultra_Sonic()
{
  digitalWrite(Trig, LOW);
  delayMicroseconds(2);
  digitalWrite(Trig, HIGH);
  delayMicroseconds(10);
  digitalWrite(Trig, LOW);
  // Pin echa jest wykorzystywany do odczytu sygnału z PING))): WYSOKI
  // impuls, którego czas trwania (podany w mikrosekundach) od wysłania
  // sygnału do odebrania jego echa od obiektu{?}.
  duration = pulseIn(echo, HIGH);
  // Konwersja czasu na odległość
  cm = microsecondsToCentimeters(duration);
  
  //Wysłanie przez port szeregowy
  Serial.print("Distance=");
  Serial.print("\t");
  Serial.print(cm);
  Serial.print("\n");
  
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//Konwersja mikrosekund na centymetry
long microsecondsToCentimeters(long microseconds)
{
// Prędkość dźwięku wynosi 340 m/s lub 29 mikrosekund na centymetr.
// Sygnał jest przesyłany tam i z powrotem, zatem by zlokalizować dystans od
// obiektu wynosi połowe przebytego dystansu. 
return microseconds / 29 / 2;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

