#!/usr/bin/env python
import sys

#Zaimportowanie modułu pujulius
import pyjulius

#Jest to implementacja kolejki FIFO, przydatna do programowania wielowątkowego.
import Queue

# Inicjalizacja obiektu klienta Julius z lokalnym adresem ip i domyślnym portem 10500. Próba połączenia z serwerem.
client = pyjulius.Client('localhost', 10500 )
try:
    client.connect()
#Jeżeli tryb klienta został uruchomiony przed wprowadzeniem do serwera, spowoduje to błąd połączenia.
except pyjulius.ConnectionError:
    print 'Najpierw uruchom program julius jako moduł!' 
    sys.exit(1)


# Rozpoczęcie nasłuchiwania serwera
client.start()
try:
    while 1:
        try:
            	#Pobieranie z serwera wyniku rozpoznawania
			result = client.results.get(False)
        except Queue.Empty:
            continue
        print result  
except KeyboardInterrupt:
    print 'Wyjście...'
    client.stop()  # Wysłanie sygnału stop
    client.join()  # czekanie na zakończenie wątku
    client.disconnect()  # Rozłączenie z julius
