//Definicja pinów enkodera

// Lewy enkoder

#define Left_Encoder_PinA 31
#define Left_Encoder_PinB 32

volatile long Left_Encoder_Ticks = 0;

//Zmienna do odczytywania bieżącego stanu pinu lewego enkodera
volatile bool LeftEncoderBSet;

//Prawy enkoder

#define Right_Encoder_PinA 33
#define Right_Encoder_PinB 34
volatile long Right_Encoder_Ticks = 0;
//Zmienna do odczytywania aktualnego stanu pinu prawego enkodera 
volatile bool RightEncoderBSet;


void setup()
{
	  //Zainicjowanie portu szeregowego na szybkość 115200 bodów
  	Serial.begin(115200);  
	SetupEncoders();
}


void SetupEncoders()
{
  // Enkodery kwadraturowe
  // Lewy enkoder
  pinMode(Left_Encoder_PinA, INPUT_PULLUP);      // Ustawienie pinu A jako wejście 
  pinMode(Left_Encoder_PinB, INPUT_PULLUP);      // Ustawienie pinu B jako wejście
  attachInterrupt(Left_Encoder_PinA, do_Left_Encoder, RISING);
  

  // Prawy enkoder
  pinMode(Right_Encoder_PinA, INPUT_PULLUP);      // Ustawienie pinu A jako wejście
  pinMode(Right_Encoder_PinB, INPUT_PULLUP);      // Ustawienie pinu B jako wejście

  attachInterrupt(Right_Encoder_PinA, do_Right_Encoder, RISING); 

}

void loop()
{
	Update_Encoders();
}


void Update_Encoders()
{
   Serial.print("e");
  Serial.print("\t");
  Serial.print(Left_Encoder_Ticks);
  Serial.print("\t");
  Serial.print(Right_Encoder_Ticks);
  Serial.print("\n");
 }

 void do_Left_Encoder()
{
   LeftEncoderBSet = digitalRead(Left_Encoder_PinB);   // Odczyt pinu wejściowego
  Left_Encoder_Ticks -= LeftEncoderBSet ? -1 : +1;
   
}
void do_Right_Encoder()
{
   RightEncoderBSet = digitalRead(Right_Encoder_PinB);   // Odczyt pinu wejściowego
  Right_Encoder_Ticks += RightEncoderBSet ? -1 : +1;
 }
