<?php
#@ _COMMENT_
# sampdb_pdo.php - Funkcje przeznaczone do obsługi bazy danych sampdb za pomocą PDO w skryptach PHP.
#@ _COMMENT_

#@ _SAMPDB_CONNECT_
# Funkcja używająca tajnej nazwy użytkownika i hasła w celu nawiązania
# połączenia z serwerem MySQL i pracy z bazą danych sampdb. Ponadto,
# włącza zgłaszanie wyjątków dla błędów, które wystąpią w kolejnych wywołaniach PDO.
# Wartością zwrotną funkcji jest uchwyt bazy danych utworzony przez new PDO().

function sampdb_connect ()
{
  $dbh = new PDO("mysql:host=localhost;dbname=sampdb",
                 "sampadm", "secret");
  $dbh->setAttribute (PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  return ($dbh);
}
#@ _SAMPDB_CONNECT_

# Funkcja generuje początkowe znaczniki HTML dla strony. Jeżeli zostaną podane parametry
# $title i $header, to przyjęto założenie, że wszystkie wszelkie znaki specjalne będą
# prawidłowo zakodowane.

#@ _HTML_BEGIN_
function html_begin ($title, $header)
{
  print ("<html>\n");
  print ("<head>\n");
  if ($title != "")
    print ("<title>$title</title>\n");
  print ("</head>\n");
  print ("<body bgcolor=\"white\">\n");
  if ($header != "")
    print ("<h2>$header</h2>\n");
}
#@ _HTML_BEGIN_

# Funkcja generuje końcowe znaczniki HTML dla strony.

#@ _HTML_END_
function html_end ()
{
  print ("</body>\n");
  print ("</html>\n");
}
#@ _HTML_END_

# Funkcja generuje elementy formularza sieciowego. Argumenty stające się częścią
# zawartości elementu są automatycznie kodowane jako HTML.

# Wyświetlenie ukrytego pola.

#@ _HIDDEN_FIELD_
function hidden_field ($name, $value)
{
  printf ("<input type=\"%s\" name=\"%s\" value=\"%s\" />\n",
          "hidden",
          htmlspecialchars ($name),
          htmlspecialchars ($value));
}
#@ _HIDDEN_FIELD_

# Wyświetlenie edytowalnego pola tekstowego.

#@ _TEXT_FIELD_
function text_field ($name, $value, $size)
{
  printf ("<input type=\"%s\" name=\"%s\" value=\"%s\" size=\"%s\" />\n",
          "text",
          htmlspecialchars ($name),
          htmlspecialchars ($value),
          htmlspecialchars ($size));
}
#@ _TEXT_FIELD_

# Wyświetlenie pola pozwalającego na podanie hasła.

function password_field ($name, $value, $size)
{
  printf ("<input type=\"%s\" name=\"%s\" value=\"%s\" size=\"%s\" />\n",
          "password",
          htmlspecialchars ($name),
          htmlspecialchars ($value),
          htmlspecialchars ($size));
}

# Wyświetlenie przycisku wyboru. Zmienna $checked powinna przyjąć wartość true, jeśli
# pole tekstowe ma być domyślnie wybrane.

#@ _RADIO_BUTTON_
function radio_button ($name, $value, $label, $checked)
{
  printf ("<input type=\"%s\" name=\"%s\" value=\"%s\"%s />%s\n",
          "radio",
          htmlspecialchars ($name),
          htmlspecialchars ($value),
          ($checked ? " checked=\"checked\"" : ""),
          htmlspecialchars ($label));
}
#@ _RADIO_BUTTON_

# Wyświetlenie przycisku wysyłającego formularz.

#@ _SUBMIT_BUTTON_
function submit_button ($name, $value)
{
  printf ("<input type=\"%s\" name=\"%s\" value=\"%s\" />\n",
          "submit",
          htmlspecialchars ($name),
          htmlspecialchars ($value));
}
#@ _SUBMIT_BUTTON_

# Funkcja script_param() wyodrębnia parametr input ze środowiska
# wykonywania skryptu.
# Jeżeli dodane zostały dodatkowe ukośniki na skutek włączenia magic_quotes_gpc,
# następuje ich usunięcie za pomocą funkcji remove_backslashes().
# Przyjęto założenie włączenia track_vars, natomiast żadne założenia nie dotyczą
# magic_quotes_gpc, a funkcja nie wymaga włączenia register_globals.

# Funkcja remove_backslashes() jest używana, gdy wartość będzie skalarana
# lub tablicą. Działa rekurencyjne, co pozwala na utworzenie formularza
# wykorzystującego możliwość tworzenia zagnieżdżonych parametrów input w PHP 4 i nowszych.

#@ _REMOVE_BACKSLASHES_
function remove_backslashes ($val)
{
  if (is_array ($val))
  {
    foreach ($val as $k => $v)
      $val[$k] = remove_backslashes ($v);
  }
  else if (!is_null ($val))
    $val = stripslashes ($val);
  return ($val);
}
#@ _REMOVE_BACKSLASHES_

#@ _SCRIPT_PARAM_
function script_param ($name)
{
  $val = NULL;
  if (isset ($_GET[$name]))
    $val = $_GET[$name];
  else if (isset ($_POST[$name]))
    $val = $_POST[$name];
  if (get_magic_quotes_gpc ())
    $val = remove_backslashes ($val);
  return ($val);
}
#@ _SCRIPT_PARAM_

# Zwrot ścieżki dostępu bieżącego skryptu.

#@ _SCRIPT_NAME_
function script_name ()
{
  return ($_SERVER["SCRIPT_NAME"]);
}
#@ _SCRIPT_NAME_

?>
