#!/usr/bin/perl
# dump_members2.pl - Wygenerowanie listy członków Ligi Historycznej.

use strict;
use warnings;
use DBI;

# Nazwa źródła danych, nazwa użytkownika, hasło i atrybuty połączenia.
my $dsn = "DBI:mysql:sampdb:localhost";
my $user_name = "sampadm";
my $password = "secret";
my %conn_attrs = (RaiseError => 0, PrintError => 0, AutoCommit => 1);

# Nawiązanie połączenia z bazą danych.
my $dbh = DBI->connect ($dsn, $user_name, $password, \%conn_attrs)
            or bail_out ("Cannot connect to database");

# Wykonanie zapytania.
my $sth = $dbh->prepare ("SELECT last_name, first_name, suffix, email,"
        . " street, city, state, zip, phone FROM member ORDER BY last_name")
          or bail_out ("Nie można przygotować zapytania.");
$sth->execute ()
  or bail_out ("Nie można nawiązać połączenia z bazą danych.");

# Odczyt i wyświetlenie wyników zapytania.
while (my @ary = $sth->fetchrow_array ())
{
  print join ("\t", @ary), "\n";
}
!$DBI::err
  or bail_out ("Błąd w trakcie pobierania danych.");

$dbh->disconnect ()
  or bail_out ("Nie można zamknąć połączenia z bazą danych.");

# Podprocedura bail_out() - wyświetlenie kodu i komunikatu błędu, a następnie zakończenie działania.

sub bail_out
{
my $message = shift;

  die "$message\nBłąd $DBI::err ($DBI::errstr)\n";
}
