<?php
# dump_members.php - Wyświetlenie członków Ligi Historycznej w tabeli HTML.

require_once "sampdb_pdo.php";

$title = "Lista członków Ligi Historycznej";
html_begin ($title, $title);

$dbh = sampdb_connect ();

# Wykonanie zapytania.
$stmt = "SELECT last_name, first_name, suffix, email,"
      . " street, city, state, zip, phone FROM member ORDER BY last_name";
$sth = $dbh->query ($stmt);

print ("<table>\n");          # Początek tabeli.
# Odczyt wyników zapytania, a następnie usunięcie danych z pamięci.
#@ _ROW_PRINT_LOOP_
while ($row = $sth->fetch (PDO::FETCH_NUM))
{
  print ("<tr>\n");           # Początek wiersza tabeli.
  for ($i = 0; $i < $sth->columnCount (); $i++)
  {
    # Cytowanie wszystkich znaków specjalnych i wygenerowanie komórki tabeli.
    print ("<td>" . htmlspecialchars ($row[$i]) . "</td>\n");
  }
  print ("</tr>\n");          # Koniec wiersza tabeli.
}
#@ _ROW_PRINT_LOOP_
print ("</table>\n");         # Koniec tabeli.

$dbh = NULL;  # Zamknięcie połączenia.

html_end ();
?>
