#!/usr/bin/perl
# flip_flop.pl - Prosty skrypt CGI.pm generujący wiele stron.

use strict;
use warnings;
use CGI qw(:standard);

my $url;
my $this_page;
my $next_page;

# Określenie strony do wyświetlenia na podstawie
# obecności lub braku parametru pageb.

if (!defined (param ("pageb"))) # Wyświetlenie strony A wraz z łączem do strony B.
{
  $this_page = "A";
  $next_page = "B";
  $url = url () . "?pageb=1";
}
else                            # Wyświetlenie strony B wraz z łączem do strony A.
{
  $this_page = "B";
  $next_page = "A";
  $url = url ();
}

print header ();
print start_html (-title => "Flip-Flop: strona $this_page",
                  -bgcolor => "white");
print p ("To jest strona $this_page. Aby wyświetlić stronę $next_page, "
         . a ({-href => $url}, "kliknij tutaj"));
print end_html ();

