<?xml version="1.0" encoding="utf-8" standalone="yes" ?>

<!-- Konwersja dokumentu zawierającego informacje o zmianach na HTML. -->

<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Nie generujemy nagłówka XML. -->

<xsl:output method="html" omit-xml-declaration="yes"/>

<!-- Sprawdzenie szablonów, aby wychwyić ewentualne błędy. -->

<xsl:template match="*">
  <xsl:message>
    <xsl:value-of select="name(.)"/>
    <xsl:text> encountered, but no template matches.</xsl:text>
  </xsl:message>
</xsl:template>

<!-- Element główny. -->

<xsl:template match="changelog">
  <html>
  <head>
  <title>
    <xsl:text>Zmiany wprowadzone w </xsl:text>
    <xsl:value-of select="book"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="distribution-name"/>
    <xsl:text> dystrybucji</xsl:text>
  </title>
  </head>
  <body bgcolor="white">
  <h2>
    <xsl:text>Zmiany wprowadzone w </xsl:text>
    <xsl:value-of select="book"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="distribution-name"/>
    <xsl:text> dystrybucji</xsl:text>
  </h2>
    <p>
    <xsl:text>W tym pliku przedstawiono listę zmian wprowadzonych w </xsl:text>
    <xsl:value-of select="distribution-name"/>
    <xsl:text> dystrybucji przeznaczonej dla książki </xsl:text>
    <xsl:value-of select="book"/>
    <xsl:text>. Zmiany podano w odwrotnej kolejności chronologicznej.</xsl:text>
    </p>
    <p>
    <xsl:text>Pliki do pobrania znajdziesz na stronie: </xsl:text>
    <a>
      <xsl:attribute name="href">
        <xsl:value-of select="downloads"/>
      </xsl:attribute>
      <xsl:value-of select="downloads"/>
    </a>
    <xsl:text>.</xsl:text>
    </p>
  <xsl:apply-templates select="changeset"/>
  </body>
  </html>
</xsl:template>

<xsl:template match="changeset">
  <p>
  <strong>
    <xsl:text>Wersja </xsl:text>
    <xsl:value-of select="version"/>
    <xsl:text> (</xsl:text>
    <xsl:value-of select="date"/>
    <xsl:text>)</xsl:text>
  </strong>
  <xsl:apply-templates select="items"/>
  </p>
</xsl:template>

<xsl:template match="items">
  <ul>
    <xsl:apply-templates select="item"/>
  </ul>
</xsl:template>

<!-- <item> może zawierać tekst lub inne elementy <items> -->

<xsl:template match="item">
  <li>
    <xsl:apply-templates/>
  </li>
</xsl:template>

</xsl:stylesheet>
