# Ten kod pokazuje jak używać ścieżki dostępu Windows w charakterze
# wartości opcji mysql_read_default_file w ciągu tekstowym nazwy źródła
# danych (DSN). Standardowo, ścieżki dostępu rozpoczynają się literą i dwukropkiem
# nie będą działały, ponieważ DBI używa dwukropka jako komponentu separatora DSN.
# Przejście do katalogu głównego napędu przed nawiązaniem połączenia powoduje, że nazwa
# pliku może być podana bez litery napędu i dwukropka. Poniższy kod najpierw zachowuje
# katalog bieżący, a następnie powraca do niego po nawiązaniu połączenia.
# W ten sposób operacja z użyciem funkcji connect() nie ma żadnego wpływu
# na katalog bieżący.

use strict;
use DBI;

#@ _FRAG_
# Zapisanie ścieżki dostępu do katalogu bieżącego.
use Cwd;
my $orig_dir = cwd ();
# Przejście do katalogu głównego dysku, na którym znajduje się plik.
chdir ("C:/") or die "Nie można zmienić katalogu: $!\n";
# Nawiązanie połączenia z użyciem parametrów zdefiniowanych w pliku C:\my.ini.
my $dsn = "DBI:mysql:sampdb:localhost;mysql_read_default_file=/my.ini";
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
my $dbh = DBI->connect ($dsn, undef, undef, \%conn_attrs);
# Powrót do poprzedniego katalogu.
chdir ($orig_dir) or die "Nie można zmienić katalogu: $!\n";
#@ _FRAG_

$dbh->disconnect ();
