#!/usr/bin/perl
# ushl_browse.pl - Przeglądanie rekordów członków Ligi Historycznej przez wyszukiwanie
# kolumny interests tabeli member.

use strict;
use warnings;
use DBI;
use CGI qw(:standard);

use Cwd;
# Plik opcji, który w systemie UNIX powinien zawierać parametry połączenia.
my $option_file = "/usr/local/apache/conf/sampdb.cnf";
my $option_drive_root;
# Nadpisanie położenia pliku w przypadku systemu Windows.
if ($^O =~ /^MSWin/i || $^O =~ /^dos/)
{
  $option_drive_root = "C:/";
  $option_file = "/Apache/conf/sampdb.cnf";
}

#@ _MAIN_BODY_1_
my $title = "Wyszukiwanie osób o podobnych zainteresowaniach";
print header ();
print start_html (-title => $title, -bgcolor => "white");
print h1 ($title);

# Sprawdzany parametr.
my $keyword = param ("keyword");

# Wyświetlenie formularza. Ponadto, jeśli zmienna $keyword ma przypisaną wartość,
# przeprowadzane jest wyszukiwanie i wyświetlenie znalezionych osób o podobnych zainteresowaniach.

print start_form (-method => "post");
print p ("Podaj szukane słowo kluczowe:");
print textfield (-name => "keyword", -value => "", -size => 40);
print submit (-name => "button", -value => "Szukaj");
print end_form ();

# Nawiązanie połączenia z serwerem i rozpoczęcie wyszukiwania, o ile podano słowo kluczowe.
if (defined ($keyword) && $keyword !~ /^\s*$/)
#@ _MAIN_BODY_1_
{
  # Przygotowanie źródła danych i nawiązanie połączenia z serwerem (w systemie Windows trzeba
  # najpierw zachować nazwę bieżącego katalogu roboczego, przejść do dysku zawierającego plik
  # opcji, nawiązać połączenie, a następnie powrócić do zapisanego katalogu bieżącego).
  my $orig_dir;
  if (defined ($option_drive_root))
  {
    $orig_dir = cwd ();
    chdir ($option_drive_root)
      or die "Nie można przejść do dysku $option_drive_root: $!\n";
  }
  my $dsn = "DBI:mysql:sampdb;mysql_read_default_file=$option_file";
  my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
  my $dbh = DBI->connect ($dsn, undef, undef, \%conn_attrs);
  if (defined ($option_drive_root))
  {
    chdir ($orig_dir)
      or die "Nie można przejść do katalogu $orig_dir: $!\n";
  }
#@ _MAIN_BODY_2_
  search_members ($dbh, $keyword);
#@ _MAIN_BODY_2_
  $dbh->disconnect ();
#@ _MAIN_BODY_3_
}
#@ _MAIN_BODY_3_

print end_html ();

#@ _SEARCH_MEMBERS_
sub search_members
{
my ($dbh, $interest) = @_;

  print p ("Wyniki wyszukiwania dla słowa kluczowego: " . escapeHTML ($interest));
  my $sth = $dbh->prepare (qq{
              SELECT * FROM member WHERE interests LIKE ?
              ORDER BY last_name, first_name
            });
  # Wyszukanie ciągu tekstowego w dowolnym miejscu kolumny interest.
  $sth->execute ("%" . $interest . "%");
  my $count = 0;
  while (my $ref = $sth->fetchrow_hashref ())
  {
    html_format_entry ($ref);
    ++$count;
  }
  print p ("Liczba dopasowanych rekordów: $count");
}
#@ _SEARCH_MEMBERS_

sub format_name
{
my $entry_ref = shift;

  my $name = $entry_ref->{first_name} . " " . $entry_ref->{last_name};
  if (defined ($entry_ref->{suffix}))     # Istnieje przyrostek dla nazwiska.
  {
    # Brak przecinka w przyrostkach typu I, II, III itd.
    $name .= "," unless $entry_ref->{suffix} =~ /^[IVX]+$/;
    $name .= " " . $entry_ref->{suffix}
  }
  return ($name);
}

#@ _HTML_FORMAT_ENTRY_
sub html_format_entry
{
my $entry_ref = shift;

  # Kodowanie znaków, które mają znaczenie specjalne w HTML.
  foreach my $key (keys (%{$entry_ref}))
  {
    next unless defined ($entry_ref->{$key});
    $entry_ref->{$key} = escapeHTML ($entry_ref->{$key});
  }
  print strong ("Name: " . format_name ($entry_ref)), br ();
  my $address = "";
  $address .= $entry_ref->{street}
                if defined ($entry_ref->{street});
  $address .= ", " . $entry_ref->{city}
                if defined ($entry_ref->{city});
  $address .= ", " . $entry_ref->{state}
                if defined ($entry_ref->{state});
  $address .= " " . $entry_ref->{zip}
                if defined ($entry_ref->{zip});
  print "Adres: $address", br ()
                if $address ne "";
  print "Telefon: $entry_ref->{phone}", br ()
                if defined ($entry_ref->{phone});
  print "E-mail: $entry_ref->{email}", br ()
                if defined ($entry_ref->{email});
  print "Zainteresowania: $entry_ref->{interests}", br ()
                if defined ($entry_ref->{interests});
  print br ();
}
#@ _HTML_FORMAT_ENTRY_
