#!/usr/bin/perl
#@ _COMMENT_
# dump_members.pl - Wygenerowanie listy członków Ligi Historycznej.
#@ _COMMENT_

#@ _USE_
use strict;
use warnings;
use DBI;
#@ _USE_

#@ _VARDECL_
# Nazwa źródła danych, nazwa użytkownika, hasło i atrybuty połączenia.
my $dsn = "DBI:mysql:sampdb:localhost";
my $user_name = "sampadm";
my $password = "secret";
my %conn_attrs = (RaiseError => 1, PrintError => 0, AutoCommit => 1);
#@ _VARDECL_

#@ _CONNECT_
# Nawiązanie połączenia z bazą danych.
my $dbh = DBI->connect ($dsn, $user_name, $password, \%conn_attrs);
#@ _CONNECT_

#@ _ISSUE_QUERY_
# Wykonanie zapytania.
my $sth = $dbh->prepare ("SELECT last_name, first_name, suffix, email,"
        . " street, city, state, zip, phone FROM member ORDER BY last_name");
$sth->execute ();
#@ _ISSUE_QUERY_

#@ _FETCH_LOOP_
# Odczyt i wyświetlenie wyników zapytania.
while (my @ary = $sth->fetchrow_array ())
{
  print join ("\t", @ary), "\n";
}
$sth->finish ();
#@ _FETCH_LOOP_

#@ _TERMINATE_
$dbh->disconnect ();
#@ _TERMINATE_
