void
process_multi_statement (MYSQL *conn, char *stmt_str)
{
MYSQL_RES *res_set;
int       status;
int       keep_going = 1;

  if (mysql_query (conn, stmt_str) != 0)  /* Wykonanie zapytania/zapytań zakończyło się niepowodzeniem. */
  {
    print_error (conn, "Nie można było wykonać zapyta(nia/ń).");
    return;
  }

  /* Wykonanie zapytania/zapytań zakończone powodzeniem; wejście do pętli pobrania wyniku. */
  do {
    /* Ustalenie, czy bieżące zapytanie zwraca dane. */
    res_set = mysql_store_result (conn);
    if (res_set)      /* Zbiór wynikowy został zwrócony. */
    {
      /* Przetworzenie rekordów i usunięcie zbioru wynikowego z pamięci. */
      process_result_set (conn, res_set);
      mysql_free_result (res_set);
    }
    else              /* Zbiór wynikowy nie został zwrócony. */
    {
      /*
       * Czy brak zbioru wynikowego oznacza brak danych wyjściowych zapytania,
       * czy raczej wskazuje na wystąpienie błędu?
       */
      if (mysql_field_count (conn) == 0)
      {
        /*
         * Zapytanie nie wygenerowało zbioru wynikowego (to nie było zapytanie typu SELECT,
         * SHOW, DESCRIBE itd.); wystarczy jedynie ustalić liczbę rekordów, których dotyczyło.
         */
        printf ("Liczba rekordów, których dotyczyło zapytanie: %lu\n",
                (unsigned long) mysql_affected_rows (conn));
      }
      else  /* Wystąpił błąd. */
      {
        print_error (conn, "Nie można było pobrać zbioru wynikowego.");
        keep_going = 0;
      }
    }
    /* Ustalenie, czy dostępnych jest więcej wyników. */
    /* 0 = tak, –1 = nie, >0 = błąd. */
    status = mysql_next_result (conn);
    if (status != 0)    /* Brak więcej wyników lub wystąpił błąd. */
    {
      keep_going = 0;
      if (status > 0)   /* Błąd. */
        print_error (conn, "Nie można było wykonać zapytania.");
    }
  } while (keep_going);
}
