import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.Timer;

/**
 * Symuluje grę zręcznościową Whack-A-Mole.
 * https://en.wikipedia.org/wiki/Whac-A-Mole
 */
public class WhackAMole implements ActionListener {

    private Drawing drawing;
    private Toolkit toolkit;

    /**
     * Konfiguruje rysunek i ramkę okna.
     */
    public WhackAMole() {

        // utwórz rysunek, dodaj wielokąty
        drawing = new MoleHill(800, 600);
        drawing.add(new Mole(150, 200));
        drawing.add(new Mole(350, 200));
        drawing.add(new Mole(550, 200));
        drawing.add(new Mole(150, 400));
        drawing.add(new Mole(350, 400));
        drawing.add(new Mole(550, 400));

        // skonfiguruj ramkę okna
        JFrame frame = new JFrame("Whack-A-Mole");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setResizable(false);
        frame.add(drawing);
        frame.pack();
        frame.setVisible(true);
        toolkit = frame.getToolkit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        toolkit.sync();
        drawing.step();
    }

    /**
     * Tworzy i uruchamia timer.
     *
     * @param args argumenty wiersza poleceń
     */
    public static void main(String[] args) {
        WhackAMole sim = new WhackAMole();
        Timer timer = new Timer(1000 / 30, sim);
        timer.start();
    }

}
