/**
 * Punkt z powiązanym kierunkiem (w stopniach).
 */
public class Pose extends Point {

    private final double heading;

    /**
     * Konstruuje pozycję w podanej lokalizacji.
     * 
     * @param x współrzędna X
     * @param y współrzędna Y
     * @param heading kierunek
     */
    public Pose(double x, double y, double heading) {
        super(x, y);
        this.heading = heading;
    }

    /**
     * @return kierunek
     */
    public double getHeading() {
        return heading;
    }

    /**
     * @return tekstowa reprezentacja pozycji
     */
    public String toString() {
        return String.format("%s @%.1f", super.toString(), this.heading);
    }

}
