/*
 * Copyright (c) 2017 Allen Downey and Chris Mayfield
 *
 * Niniejszym udziela się bezpłatnie każdej osobie posiadającej kopię tego oprogramowania 
 * i związanych z nim plików dokumentacji (zwanych dalej „Oprogramowaniem”) pozwolenia na korzystanie
 * z Oprogramowania bez ograniczeń, w tym między innymi bez ograniczenia praw do używania,
 * kopiowania, modyfikowania, łączenia, publikowania, rozpowszechniania, udzielania sublicencji
 * i/lub sprzedawania kopii Oprogramowania oraz zezwalania na to osobom, którym Oprogramowanie
 * zostało dostarczone, z zastrzeżeniem następujących warunków:
 *
 * Powyższa informacja o prawach autorskich i niniejsza informacja o pozwoleniu będą zawarte
 * we wszystkich kopiach lub znacznych fragmentach tego Oprogramowania.
 *
 * OPROGRAMOWANIE JEST DOSTARCZANE „W STANIE, W JAKIM JEST”, BEZ ŻADNEJ GWARANCJI,
 * WYRAŹNEJ LUB DOROZUMIANEJ, W TYM, ALE BEZ OGRANICZENIA DO, GWARANCJI PRZYDATNOŚCI
 * HANDLOWEJ, PRZYDATNOŚCI DO OKREŚLONEGO CELU I NARUSZENIA. W ŻADNYM WYPADKU AUTORZY
 * ANI POSIADACZE PRAW AUTORSKICH NIE PONOSZĄ ODPOWIEDZIALNOŚCI ZA JAKIEKOLWIEK ROSZCZENIE,
 * SZKODY LUB INNE ODPOWIEDZIALNOŚCI, CZY TO W DZIAŁANIU UMOWY, DELIKTU LUB INNYM PRZYPADKU
 * WYNIKAJĄCYM Z LUB POWSTAJĄCYM Z, LUB W ZWIĄZKU Z OPROGRAMOWANIEM LUB WYKORZYSTANIEM GO,
 * CZY INNYMI DZIAŁANIAMI Z OPROGRAMOWANIEM. 
 */

import java.util.Scanner;

/**
 * Klasa narzędziowa umożliwiająca konwersję jednostek na system metryczny i w drugą stronę.
 *
 * @author Allen Downey
 * @author Chris Mayfield
 * @version 6.1.5
 */
public class Convert {

    public static final double CM_PER_INCH = 2.54;

    public static final int IN_PER_FOOT = 12;

    /**
     * Konwertuje pomiar wyrażony w centymetrach na cale.
     *
     * @param cm długość w centymetrach
     * @return długość w calach
     */
    public static double toImperial(double cm) {
        return cm / CM_PER_INCH;
    }

    /**
     * Konwertuje długość podaną w stopach i calach na centymetry.
     *
     * @param feet liczba stóp
     * @param inches liczba cali
     * @return długość w centymetrach
     */
    public static double toMetric(int feet, int inches) {
        int total = feet * IN_PER_FOOT + inches;
        return total * CM_PER_INCH;
    }

    /**
     * Testuje metody konwertujące.
     *
     * @param args argumenty wiersza poleceń
     */
    public static void main(String[] args) {
        double cm, result;
        int feet, inches;
        Scanner in = new Scanner(System.in);

        // test konwersji na cale
        System.out.print("Ile dokładnie cm? ");
        cm = in.nextDouble();
        result = toImperial(cm);
        System.out.printf("To %.2f cali\n", result);
        System.out.println();

        // test konwersji na jednostki metryczne
        System.out.print("Ile stóp? ");
        feet = in.nextInt();
        System.out.print("I ile cali? ");
        inches = in.nextInt();
        result = toMetric(feet, inches);
        System.out.printf("To %.2f cm\n", result);
    }
}
