import java.util.ArrayList;

/**
 * Stos kart do gry (o zmiennej wielkości).
 */
public class Pile {

    private ArrayList<Card> cards;

    /**
     * Konstruuje pusty stos kart.
     */
    public Pile() {
        this.cards = new ArrayList<Card>();
    }

    /**
     * Dodaje kartę na spód stosu.
     */
    public void addCard(Card card) {
        this.cards.add(card);
    }

    /**
     * Kopiuje całą talię do stosu.
     */
    public void addDeck(Deck deck) {
        for (Card card : deck.getCards()) {
            this.cards.add(card);
        }
    }

    /**
     * Usuwa kartę ze szczytu stosu.
     */
    public Card popCard() {
        return this.cards.remove(0);
    }

    /**
     * Zwraca liczbę kart należących do stosu.
     */
    public int size() {
        return this.cards.size();
    }

}
