import java.awt.Polygon;

/**
 * Wielokąt o trzech bokach.
 */
public class Triangle extends Polygon {

    /**
     * Konstruuje trójkąt o wierzchołkach znajdujących się w podanych punktach.
     * 
     * @param ax pierwsza współrzędna x
     * @param ay pierwsza współrzędna y
     * @param bx druga współrzędna x
     * @param by druga współrzędna y
     * @param cx trzecia współrzędna x
     * @param cy trzecia współrzędna y
     */
    public Triangle(int ax, int ay, int bx, int by, int cx, int cy) {

        // sprawdź, czy da się utworzyć trójkąt
        int lhs = (cy - by) * (bx - ax);
        int rhs = (by - ay) * (cx - bx);
        if (lhs == rhs) {
            throw new IllegalArgumentException("punkty są współliniowe");
        }

        // zapisz punkty tworzące wielokąt
        xpoints = new int[] {ax, bx, cx};
        ypoints = new int[] {ay, by, cy};
        npoints = 3;
    }

    /**
     * @return tekstowa repreentacja trójkąta
     */
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Trójkąt[");
        for (int i = 0; i < npoints; i++) {
            if (i > 0) {
                str.append(", ");
            }
            // dodaj następny punkt (x, y)
            str.append('(');
            str.append(xpoints[i]);
            str.append(", ");
            str.append(ypoints[i]);
            str.append(')');
        }
        str.append(']');
        return str.toString();
    }
}
