import java.io.*;
import java.net.*;

/*
 * The Server for TextMessage.
 */
public class Server {

	public static void main(String[] arg) {

		// create a reference for an object to come from the client.
		TextMessage myTextMessage = null;

		try {

			// Start the Server listening to port 11111
			ServerSocket myServerSocket = new ServerSocket(11111);

			System.out.println("Ready\n");

			// Wait here until a Client attempts to connect
			Socket incoming = myServerSocket.accept();

			// Create an ObjectInputStream
			ObjectInputStream myInputStream 
				= new ObjectInputStream(incoming.getInputStream());

			// Read the object from the socket that has the client 
			myTextMessage = (TextMessage)myInputStream.readObject();

			System.out.println(myTextMessage.getName() + " : " 
                              + myTextMessage.getTextMessage()+ "\n");

			// Close the streams
			myInputStream.close();

		}  catch(Exception e) {

			System.out.println(e);
		}
 
	}

}
