using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Net;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using System.Runtime.Serialization;

namespace Server
{
    class Server
    {
        public Server()
        {
            TcpListener server = null;
            TcpClient client = null;
            try
            {
                //Create our Socket Listener and start it
                server = new TcpListener(IPAddress.Parse("127.0.0.1"), 11111);
                server.Start();

                //Setup our input buffer
                Byte[] bytes = new Byte[256];

                //Loop indefinitely
                while (true)
                {
                    //Begin accepting incoming transmissions in block mode
                    client = server.AcceptTcpClient();
                    Console.WriteLine("Connected!");

                    //Open our stream
                    NetworkStream stream = client.GetStream();

                    //Read all the data from the stream
                    int i;
                    while ((i = stream.Read(bytes, 0, bytes.Length)) != 0)
                    {
                        //Prepare a format that the Serializer can read
                        MemoryStream ms = new MemoryStream(bytes);
                        //Prepare the Serializer              
                        XmlSerializer myXmlFactory = 
                            new XmlSerializer(typeof(CheckingAccount));
                        //Create our CheckingAccount from the stream           
                        myRestoredAccount = 
                            (CheckingAccount)myXmlFactory.Deserialize(ms);
                        //Now demonstrate that the object is indeed created
                        Console.WriteLine("Name: {0}, Account Number: {1}.",
                            myRestoredAccount.Name, myRestoredAccount.AccountNumber);
                        //Throw an exception to exit the loop
                        throw new Exception("ignore");
                    }
                }
            }
            catch (Exception ex)
            {
                if (!ex.Message.Equals("ignore")) 
			{ Console.WriteLine("Exception: {0}", ex); } 
            }
            finally
            {
                //Close our resources
                client.Close();
                server.Stop();
            }
            Console.WriteLine("Press any key to continue...");
            Console.ReadKey();
        }
    }
}
