// Class Person
using System;
using System.Collections;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace CSSerial
{   
    [XmlRoot("person")]
    public class Person
    {
        private String _Name;
        private int _Age;
        private int _Score;
        
        public Person()
        {
            Name = "John Doe";
            Age=25;
            Score=50;
        }

        public Person(String name, int age, int score)
        {
            _Name = name;
            _Age = age;
            _Score = score;
        }
        [XmlAttribute("name")]
        public String Name
        {
            get
            {
                return _Name;
            }
            set
            {
                if (value == null) return;
                _Name = value;
            }
        }

        [XmlElement("age")]
        public int Age
        {
            get 
            {
                return _Age;
            }
            set 
            {
                _Age = value;
            }
        }

        [XmlIgnore()]
        public int Score
        {
            get
            {
                return _Score; 
            }
            set 
            {
                _Score = value; 
            }
        }
    }
}
