Module Main

    Sub Main()
        Dim SerialDemo As PreservePerson = New PreservePerson()
        Console.WriteLine("Press any key to continue...")
        Console.ReadKey()
    End Sub

End Module

Imports System.IO
Imports System.Xml
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.Runtime.Serialization

Public Class PreservePerson
    Sub New()
        'First Create the person and write it to disk
        Dim myPerson As Person = New Person("Jack Jacobs")
        Console.WriteLine("Name Before Serialization: " & myPerson.Name)
        serializePerson(myPerson)
        myPerson = Nothing

        'Now make a new person from the saved object
        Dim myRestoredPerson As Person = deserializePerson()
        Console.WriteLine("Name After Serialization: " & myRestoredPerson.Name)
    End Sub

    Public Sub serializePerson(ByVal p As Person)
        Try
            Dim xmlSerializer As Serialization.XmlSerializer
            Dim strWriter As New StringWriter()
            Dim dataFile As FileStream = New FileStream("Sample.xml", FileMode.Create, FileAccess.Write, FileShare.None)
            xmlSerializer = New Serialization.XmlSerializer(GetType(Person))
            xmlSerializer.Serialize(dataFile, p)
            dataFile.Close()
        Catch ex As Exception
            Console.WriteLine(ex.Message & vbCrLf & ex.StackTrace)
        End Try
    End Sub

    Public Function deserializePerson() As Person
        Dim p As Person
        Try
            Dim dataFile As FileStream = File.Open("Sample.xml", FileMode.Open, FileAccess.Read)
            Dim xmlSerializer As New Serialization.XmlSerializer(GetType(Person))

            ' Create the new Person object from the serialization.
            p = xmlSerializer.Deserialize(dataFile)
            dataFile.Close()
        Catch ex As Exception
            Console.WriteLine(ex.Message)
            Console.WriteLine(ex.StackTrace)
            p = Nothing
        End Try
        Return p
    End Function
End Class
