#!/usr/bin/perl -w

# Skrypt 8.6, 'show_tables2.pl'
# Skrypt oczekuje podania bazy danych 
# jako argumentu wiersza polece i wywietla
# tabele z podanej bazy danych.

# Doczenie potrzebnych moduw.
use strict;
use DBI;

# W czasie wywoania skrypt pobiera jeden argument.
# Jest nim nazwa bazy danych.
my $database = $ARGV[0];

if (defined($database)) {

  # Podczenie do bazy danych.
  my $dbh = DBI->connect("DBI:mysql:$database:localhost", 'username', 'password', {PrintError => 0, RaiseError => 0});
  
  # Sprawdzenie bdw.
  if (DBI->err()) {
    print "Nie mona podczy si do bazy danych! Bd MySQL: " . DBI->errstr() . "\n";
    exit(1);
  }
  
  # Wykonanie zapytania.
  my $sth = $dbh->prepare('SHOW TABLES');
  
  if (defined($sth)) {
    $sth->execute();
    
    # Sprawdzenie bdw.
    if ($sth->err()) {
      print "Nie mona wykona zapytania! Bd MySQL: " . $sth->errstr() . "\n";
    } else {
      my @row;
      while (@row = $sth->fetchrow_array()) {
        print "$row[0]\n";
      }
      $sth->finish();
    }
  } else {
    print "Nie mona przygotowa zapytania! Bd MySQL: " . $dbh->errstr() . "\n";
  }
  
  # Odczenie.
  $dbh->disconnect;
  
} else {
  print "Prosz poda nazw bazy danych jako argument tego skryptu! \n";
}
