-- --------------------------------------------------------
-- Rozdzia 2.
-- --------------------------------------------------------

CREATE DATABASE welna;
CREATE DATABASE filmy;

GRANT SELECT, INSERT, UPDATE, DELETE, CREATE, DROP, ALTER, INDEX ON alpacas.* TO 'lama'@'localhost' IDENTIFIED BY 'wielblad';

GRANT FILE ON *.* TO  'lama'@'localhost';
GRANT CREATE ROUTINE, ALTER ROUTINE, EXECUTE, CREATE VIEW, SHOW VIEW ON alpacas.* TO 'lama'@'localhost';

GRANT USAGE ON *.* TO 'webuser'@'%' IDENTIFIED BY 'BroWs1ng';
GRANT SELECT ON alpacas.* TO 'webuser'@'%';
GRANT SELECT ON movies.* TO 'webuser'@'%';


-- --------------------------------------------------------
-- Rozdzia 4:
-- --------------------------------------------------------


CREATE DATABASE finanse;


USE finanse;

CREATE TABLE faktury (
faktura_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
klient_id SMALLINT(3) UNSIGNED NOT NULL,
data_faktury TIMESTAMP NOT NULL,
wartosc_faktury DECIMAL(10,2) UNSIGNED NOT NULL,
opis_faktury TINYTEXT NOT NULL,
data_platnosci DATE,
PRIMARY KEY (faktura_id),
INDEX (klient_id),
INDEX (data_faktury),
INDEX (wartosc_faktury),
INDEX (data_platnosci)
);


CREATE TABLE klienci (
klient_id SMALLINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
nazwa_klienta VARCHAR(40) NOT NULL,
ulica_klienta VARCHAR(80) NOT NULL,
miasto_klienta VARCHAR(30) NOT NULL,
stan_klienta VARCHAR(2) NOT NULL,
kod_pocztowy_klienta MEDIUMINT(5) UNSIGNED ZEROFILL NOT NULL,
telefon_klienta VARCHAR(14),
osoba_kontaktowa_imie VARCHAR(15),
osoba_kontaktowa_nazwisko VARCHAR(25),
email_kontaktowy VARCHAR(60),
PRIMARY KEY (klient_id),
INDEX (nazwa_klienta)
);

CREATE TABLE wydatki (
wydatek_id SMALLINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
kategoria_wydatku_id TINYINT(3) UNSIGNED NOT NULL,
wartosc_wydatku DECIMAL(10,2) UNSIGNED NOT NULL,
opis_wydatku TINYTEXT NOT NULL,
data_zaplaty DATE NOT NULL,
PRIMARY KEY (wydatek_id),
INDEX (kategoria_wydatku_id),
INDEX (wartosc_wydatku),
INDEX (data_zaplaty)
);

CREATE TABLE wydatki_kategorie (
kategoria_wydatku_id TINYINT(3) UNSIGNED NOT NULL AUTO_INCREMENT,
kategoria_wydatku VARCHAR(30) NOT NULL,
PRIMARY KEY (kategoria_wydatku_id),
UNIQUE (kategoria_wydatku)
);


-- --------------------------------------------------------
-- Rozdzia 5:
-- --------------------------------------------------------


USE finanse;

INSERT INTO wydatki_kategorie (kategoria_wydatku) VALUES ('Podr-hotel');

INSERT INTO wydatki_kategorie VALUES (NULL, 'Podr-bilet lotniczy');

INSERT INTO wydatki_kategorie VALUES
(NULL, 'Ksiki'),
(NULL, 'Witryna internetowa'),
(NULL, 'Oprogramowanie komputerowe');


INSERT INTO wydatki_kategorie (kategoria_wydatku) VALUES 
('Prenumeraty czasopism'), 
('Sprzt komputerowy'), 
('Papier cierny'), 
('Bbny cierne'), 
('Tama klejca'), 
('Gummki'), 
('Sanday'), 
('Podkowy'), 
('Tablice'), 
('spinacze'), 
('Jajka'), 
('Wyczniki'), 
('Elektryczno'), 
('Tusz do drukarek'), 
('Ramki do zdj'), 
('Opaty za dostp do internetu'), 
('Owki'), 
('Premie pracownikw');



INSERT INTO klienci VALUES 
(NULL,  'Acme Industries',  '100 Main Street',  
'Anytown',  'NY',  11111,  '(888) 555-1234',  
'Jane',  'Doe',  'Jane@acme_industries.com');

INSERT INTO klienci (nazwa_klienta,  osoba_kontaktowa_imie,  osoba_kontaktowa_nazwisko) VALUES 
('Winesburg Press',  'Sherwood',  'Anderson');

INSERT INTO klienci VALUES 
(NULL,  'Galt on the Hill',  '1000 Tuttle Drive',  
'Brazilia',  'IL',  60000,  NULL,  NULL,  
'doe',  'jimmy.johns@example.com');


INSERT INTO klienci (nazwa_klienta,  osoba_kontaktowa_imie,  osoba_kontaktowa_nazwisko) VALUES 
('ABC Noun',  'Clarissa',  'Jones');

INSERT INTO klienci VALUES (NULL,  'The Enterprises',  '200 Main Street',  'Anytown',  'NY',  11111,  '(800) 555-5555',  'John',  'Doe',  'Johnny_D@theenterprises.com');

INSERT INTO klienci VALUES (NULL,  'Another Client',  '4 Some Ave',  'Newark',  'NJ',  07100,  NULL,  'Art',  'Vanderlay',  NULL);

INSERT INTO klienci VALUES (NULL,  'Nepotism Inc.',  '693 Grand Blvd.',  'Fictional',  'ST',  89756,  NULL,  'Joey',  'B.',  'info@web-address.edu');

INSERT INTO klienci VALUES (NULL,  'Something Clever',  'Some Road',  'Some City',  'OK',  64165,  NULL,  'Daryl',  'Zero',  NULL);

INSERT INTO klienci VALUES (NULL,  'MiddleEarth Software',  '3902 4th Street',  'Patterson',  'NJ',  07509,  NULL,  'Rebecca',  NULL,  NULL);


INSERT INTO wydatki VALUES 
(NULL, 3, '19.99', 'Larry Ullman "MySQL. Szybki start"', '2006-04-20');
INSERT INTO wydatki VALUES 
(NULL, 1, '104.50', 'Hotel Palmer House,  Chicago', '2006-01-26');
INSERT INTO wydatki VALUES 
(NULL, 2, '689.00', 'Przelot do Chicago', '2006-01-26');
INSERT INTO wydatki VALUES 
(NULL, 5, '99.99', 'Mmmm...oprogramowanie', '2006-01-12');

INSERT INTO wydatki VALUES 
(NULL, 2, '64.99', 'Przelot z Chicago', '2006-04-20');
INSERT INTO wydatki VALUES 
(NULL, 7, '64.50', 'Apple PowerBook', '0000-00-00');
INSERT INTO wydatki VALUES 
(NULL, 10, '6464.00', 'Rzebienie', '2006-01-26');
INSERT INTO wydatki VALUES (NULL, 22, '67.94', 'Pisanie implementacji dla maych bbelkw w testach.', '2006-04-20');
INSERT INTO wydatki VALUES 
(NULL, 14, '1.97', 'Rekonstrukcja', '2006-04-20');
INSERT INTO wydatki VALUES 
(NULL, 8, '3216.00', 'Szlifowanie', '2006-01-26');
INSERT INTO wydatki VALUES 
(NULL, 8, '9712.97', 'Mnstwo szlifowania czeka.', '2006-01-26');
INSERT INTO wydatki VALUES 
(NULL, 5, '312.64', 'Aktualizacja oprogramowania.', NULL);
INSERT INTO wydatki VALUES 
(NULL, 20, '25.00', 'Ramka do zawieszenia dyplomu Jess.', '2006-05-09');
INSERT INTO wydatki VALUES 
(NULL, 21, '39.99', 'Miesiczna opata za kablowy dostp do internetu.', '2006-05-09');
INSERT INTO wydatki VALUES 
(NULL, 3, '19.99', 'Larry Ullman "PHP. Tworzenie stron dla WWW. Szybki start".', '2006-05-09');
INSERT INTO wydatki VALUES 
(NULL, 3, '29.99', 'Larry Ullman "PHP.  Advanced for the World Wide Web: Visual QuickPro Guide"', '2006-05-24');
INSERT INTO wydatki VALUES 
(NULL, 5, '129.00', 'Oprogramowanie do tworzenia wizualnej reprezentacji baz danych.', '2006-05-24');


INSERT INTO faktury VALUES (NULL,4,'2006-04-24','1902.34','Koniugacja: czasowniki, rzeczowniki, przymiotniki.', NULL);
INSERT INTO faktury VALUES (NULL,4,'2008-07-20','942.00','Tekst techniczny.', NULL);


INSERT INTO faktury VALUES (NULL,2,'2007-07-20','54.25','Ucisk doni', NULL);
INSERT INTO faktury VALUES (NULL,3,'2006-04-24','1.00','Usugi rne', NULL);
INSERT INTO faktury VALUES (NULL,1,'2006-04-10','654.34','Praca, praca, praca.', NULL);
INSERT INTO faktury VALUES (NULL,1,'2008-01-20','98754.00','Pisma techniczne.', NULL);
INSERT INTO faktury VALUES (NULL,2,'2007-07-18','54.25','Napdzanie.', NULL);
INSERT INTO faktury VALUES (NULL,3,'2006-04-24','3210.84','Przemylenia', NULL);
INSERT INTO faktury VALUES (NULL,4,'2007-04-08','6.64','Ciemny interes.', NULL);
INSERT INTO faktury VALUES (NULL,4,'2008-11-20','2.00','Rozjasnianie.', NULL);
INSERT INTO faktury VALUES (NULL,5,'2001-07-03','9.96','Lepiej nie pyta.', NULL);
INSERT INTO faktury VALUES (NULL,2,'2006-04-22','315.94','Usugi rne', NULL);
INSERT INTO faktury VALUES (NULL,3,'2006-12-24','9751.94','Czytanie.', NULL);
INSERT INTO faktury VALUES (NULL,4,'2006-07-20','321.55','Projekt strony WWW, PHP, MySQL.', NULL);
INSERT INTO faktury VALUES (NULL,6,'2001-07-27','2.55','Ucisk doni', NULL);
INSERT INTO faktury VALUES (NULL,7,'2007-10-24','64.64','Usugi rne', NULL);


UPDATE klienci SET telefon_klienta = '(800) 123-4567' WHERE klient_id = 2;




SELECT * FROM wydatki_kategorie
ORDER BY kategoria_wydatku ASC;

DELETE FROM wydatki_kategorie WHERE
kategoria_wydatku_id IN (1, 2);

INSERT INTO wydatki_kategorie VALUES (NULL, 'Podr');

SELECT kategoria_wydatku_id FROM
wydatki_kategorie WHERE
kategoria_wydatku='Podr';

UPDATE wydatki SET kategoria_wydatku_id = 24
WHERE kategoria_wydatku_id IN (1, 2);

-- --------------------------------------------------------
-- rozdzia 6:
-- --------------------------------------------------------



CREATE TABLE uzytkownicy(
uzytkownik_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
klient_id SMALLINT UNSIGNED NOT NULL,
nazwa TINYBLOB,
haslo CHAR(40),
PRIMARY KEY(uzytkownik_id)
);


INSERT INTO uzytkownicy
(klient_id, nazwa, haslo) VALUES
(4, AES_ENCRYPT('larryeullman', 'w1cKet'), SHA1('larryPASS'));

SELECT klient_id FROM uzytkownicy WHERE (haslo = SHA1('larryPASS') AND AES_DECRYPT(nazwa, 'w1cKet') = 'larryeullman');


INSERT INTO uzytkownicy
(klient_id, nazwa, haslo) VALUES
(4, AES_ENCRYPT('homerjsimpson', 'w1cKet'), SHA1('D\'ohReMi'));

SELECT LAST_INSERT_ID();

SELECT DISTINCT(faktury.klient_id),
nazwa_klienta FROM faktury, klienci
WHERE faktury.klient_id = klienci.klient_id;

SELECT COUNT(DISTINCT(klient_id))
FROM faktury;


-- --------------------------------------------------------
-- rozdzia 10:
-- --------------------------------------------------------



USE test;

CREATE TABLE konta (
id INT UNSIGNED NOT NULL AUTO_INCREMENT,
imie VARCHAR(20) NOT NULL,
nazwisko VARCHAR(40) NOT NULL,
stan DECIMAL(10,2) NOT NULL DEFAULT 0.0,
PRIMARY KEY (id),
INDEX (nazwisko)
) ENGINE=InnoDB;

INSERT INTO konta VALUES 
(NULL, 'Sylwia', 'Spgoska', 5460.23), 
(NULL, 'Dawid', 'Sitkiewicz', 909325.24), 
(NULL, 'Umma', 'Gumma', 892.00);


START TRANSACTION;

UPDATE konta SET stan=(stan-100) WHERE id=2;

UPDATE konta SET stan=(stan+100) WHERE id=1;

SELECT * FROM konta;

ROLLBACK;

SELECT * FROM konta;

START TRANSACTION;

UPDATE konta SET stan=(stan-100) WHERE id=2;

UPDATE konta SET stan=(stan+100) WHERE id=1;

COMMIT;
SELECT * FROM konta;



USE finanse;

SELECT opis_wydatku FROM wydatki;
ALTER TABLE wydatki ADD FULLTEXT (opis_wydatku);
SHOW CREATE TABLE wydatki \G

USE finanse;

SELECT wydatek_id, opis_wydatku
FROM wydatki WHERE 
MATCH (opis_wydatku) AGAINST ('oprogramowanie');

SELECT wydatek_id, opis_wydatku, 
MATCH (opis_wydatku) AGAINST ('tworzenie szybki') AS rel 
FROM wydatki WHERE 
MATCH (opis_wydatku) AGAINST ('tworzenie szybki') \G

USE finanse;


SELECT wydatek_id, opis_wydatku, 
MATCH (opis_wydatku) AGAINST ('+visual +guide' IN BOOLEAN MODE) AS rel 
FROM wydatki WHERE 
MATCH (opis_wydatku) AGAINST ('+visual +guide' IN BOOLEAN MODE) ORDER BY rel DESC \G

SELECT wydatek_id, opis_wydatku, 
MATCH (opis_wydatku) AGAINST ('+visual +guide >quickpro' IN BOOLEAN MODE) AS rel 
FROM wydatki WHERE 
MATCH (opis_wydatku) AGAINST ('+visual +guide >quickpro' IN BOOLEAN MODE) ORDER BY rel DESC \G



USE finanse;

SELECT nazwa_klienta, telefon_klienta FROM klienci WHERE telefon_klienta
REGEXP '^(800)|(888)|(877)';


SELECT nazwa_klienta, telefon_klienta 
FROM klienci WHERE telefon_klienta
REGEXP '^[(]?8{1}(00|88|77)';


SELECT nazwa_klienta, osoba_kontaktowa_imie, email_kontaktowy FROM klienci 
WHERE email_kontaktowy NOT REGEXP 
'^[[:alnum:]_\.]+@.*\.[[:alnum:]]{2,3}';



USE finanse;

CREATE TABLE sodium (
salt CHAR(6) NOT NULL
);
INSERT INTO sodium (salt) VALUES ('w1cKet');
SELECT @salt:=salt FROM sodium;
INSERT INTO uzytkownicy 
(klient_id, nazwa, haslo) 
VALUES (3, AES_ENCRYPT('Izabela', @salt), SHA1('atticus7'));
SELECT @salt:=salt FROM sodium;
SELECT klient_id, AES_DECRYPT(nazwa, @salt) AS nazwa FROM uzytkownicy;
SELECT @salt;



USE test;

CREATE TABLE tabela1 (
id TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
napis VARCHAR(10),
data DATE,
PRIMARY KEY (id)
);
INSERT INTO tabela1 (napis, data) VALUES 
('kot', '2006-03-10'), ('pies', '2006-02-06'), ('mysz', '2006-02-24'); 
CREATE TABLE tabela2 (
inny_id TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
inny_napis VARCHAR(10),
inna_data DATE,
PRIMARY KEY (inny_id)
) AUTO_INCREMENT=3;
INSERT INTO tabela2 (inny_napis, inna_data) VALUES 
('rzeczownik', '2006-03-10'), ('czasownik', '2006-03-24'), ('kot', '2006-04-20'); 


-- --------------------------------------------------------
-- Rozdzia 11:
-- --------------------------------------------------------


USE finanse;

SELECT klient_id, AES_DECRYPT(nazwa, 'w1cKet') 
FROM uzytkownicy ORDER BY klient_id;

DELIMITER $$

CREATE PROCEDURE add_login 
(cid INT, name VARCHAR(20), pass VARCHAR(20)) 
BEGIN
INSERT INTO uzytkownicy 
(klient_id, nazwa, haslo) 
VALUES 
(cid, AES_ENCRYPT(name, 'w1cKet'), SHA1(pass));
END $$

DELIMITER ;

CALL add_login (9, 'cokolwiek', 'mojehaslo');

SELECT klient_id, AES_DECRYPT(nazwa, 'w1cKet') FROM uzytkownicy ORDER BY klient_id;

USE finanse;

DELIMITER $$

CREATE FUNCTION days_old (d DATE) RETURNS INT
BEGIN
    RETURN DATEDIFF(d, CURDATE());
END $$

DELIMITER ;

SELECT faktura_id, days_old(data_faktury) AS dni_niezaplacone 
FROM faktury WHERE data_platnosci IS NULL 
ORDER BY dni_niezaplacone ASC;

USE finanse;

DELIMITER $$

CREATE FUNCTION capitalize 
(str VARCHAR(30)) RETURNS VARCHAR(30) 
BEGIN
    DECLARE s1 CHAR;
    DECLARE s2 VARCHAR(29);
    SET s1 = UPPER(LEFT(str, 1));
    SET s2 = SUBSTR(LOWER(str) FROM 2);
    RETURN CONCAT(s1, s2);
END $$
DELIMITER ;

SELECT capitalize('pawe');

SELECT capitalize(osoba_kontaktowa_imie) AS fn, capitalize(osoba_kontaktowa_nazwisko) AS ln FROM klienci;

USE finanse;

DELIMITER $$

CREATE FUNCTION is_overdue (d DATE) RETURNS BOOLEAN
BEGIN
    DECLARE num INT;
    SET num = DATEDIFF(d, CURDATE());
    IF num < -45 THEN RETURN TRUE;
    ELSE RETURN FALSE;
    END IF;
END $$

DELIMITER ;

SELECT faktura_id, wartosc_faktury, 
days_old(data_faktury) AS days 
FROM faktury WHERE data_platnosci IS NULL 
AND is_overdue(data_faktury); 

USE test;

CREATE TABLE liczby_losowe (
    liczba INT UNSIGNED NOT NULL
);

DELIMITER $$

CREATE PROCEDURE populate (many INT)
BEGIN
    DECLARE i INT DEFAULT 1;
    WHILE i <= many DO
        INSERT INTO liczby_losowe 
        VALUES (FLOOR(1 + RAND() * 100));
        SET i = i + 1;
    END WHILE;
END $$

DELIMITER ;

CALL populate (10);
CALL populate (5);

SELECT * FROM liczby_losowe;

USE finanse;

DELIMITER $$

CREATE PROCEDURE check_login (name VARCHAR(20), pass VARCHAR(20), OUT cid INT) 
BEGIN
  SELECT klient_id INTO cid FROM uzytkownicy 
  WHERE nazwa=AES_ENCRYPT(name, 'w1cKet') 
  AND haslo=SHA1(pass);
END $$

DELIMITER ;

CALL check_login ('uzytkownik', 'haslo', @id);
SELECT @id;
CALL check_login ('bad', 'bad', @id);
SELECT @id;


CREATE DATABASE ehandel;
USE ehandel;

CREATE TABLE przedmioty (
przedmiot_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
nazwa_przedmiotu VARCHAR(40) NOT NULL,
cena_przedmiotu DECIMAL(10,2) UNSIGNED NOT NULL,
ilosc_przedmiotow MEDIUMINT UNSIGNED NOT NULL DEFAULT 0,
PRIMARY KEY (przedmiot_id),
INDEX (nazwa_przedmiotu),
INDEX (cena_przedmiotu),
INDEX (ilosc_przedmiotow)
);

CREATE TABLE zamowienia (
zamow_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
przedmiot_id INT UNSIGNED NOT NULL,
PRIMARY KEY (zamow_id),
INDEX (przedmiot_id)
);

INSERT INTO przedmioty VALUES 
(NULL, 'a', 19.95, 20),
(NULL, 'b', 15.00, 10),
(NULL, 'c',  22.95, 5),
(NULL, 'd', 10.00, 15);

DELIMITER $$

CREATE TRIGGER update_qty_insert 
AFTER INSERT ON zamowienia FOR EACH ROW 
BEGIN
    UPDATE przedmioty SET 
ilosc_przedmiotow=ilosc_przedmiotow-1 
WHERE przedmioty.przedmiot_id=NEW.przedmiot_id;
END $$

CREATE TRIGGER update_qty_delete 
BEFORE DELETE ON zamowienia FOR EACH ROW 
BEGIN
    UPDATE przedmioty SET 
ilosc_przedmiotow=ilosc_przedmiotow+1 
WHERE przedmioty.przedmiot_id=OLD.przedmiot_id;
END $$

DELIMITER ;

INSERT INTO zamowienia (przedmiot_id) 
VALUES (1), (2), (3), (1), (1);

SELECT * FROM przedmioty;

DELETE FROM zamowienia WHERE zamow_id=4;

SELECT * FROM przedmioty;


USE finanse;

SELECT kategoria_wydatku AS kategoria, 
SUM(wartosc_wydatku) AS suma 
FROM wydatki_kategorie AS ec 
LEFT JOIN wydatki 
USING (kategoria_wydatku_id) 
GROUP BY ec.kategoria_wydatku_id;

CREATE VIEW suma_wydatkow AS 
SELECT kategoria_wydatku AS kategoria, 
SUM(wartosc_wydatku) AS suma 
FROM wydatki_kategorie AS ec 
LEFT JOIN wydatki 
USING (kategoria_wydatku_id) 
GROUP BY ec.kategoria_wydatku_id;

CREATE VIEW zalegle_faktury AS 
SELECT nazwa_klienta AS klient,
SUM(wartosc_faktury) AS suma,
COUNT(faktura_id) AS faktury
FROM faktury JOIN klienci USING (klient_id) 
WHERE data_platnosci IS NULL 
AND is_overdue(data_faktury) 
GROUP BY faktury.klient_id;

SHOW TABLES;

USE finanse;

SELECT kategoria FROM suma_wydatkow
WHERE suma IS NULL;

SELECT * FROM zalegle_faktury;

SELECT faktura_id, wartosc_faktury, nazwa_klienta
FROM klienci JOIN faktury 
USING (klient_id) 
WHERE is_overdue(data_faktury);
UPDATE faktury 
SET data_platnosci=NOW()
WHERE faktura_id IN (3, 4, 7, 10, 11);

SELECT * FROM zalegle_faktury;

-- --------------------------------------------------------
-- Rozdzia 12:
-- --------------------------------------------------------



CREATE DATABASE dane_binarne;
USE dane_binarne;

CREATE TABLE obrazy (
obraz_id int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
obraz LONGBLOB,
nazwa_obrazu VARCHAR(60) NOT NULL,
typ_obrazu VARCHAR(12) NOT NULL,
szer_obrazu MEDIUMINT UNSIGNED NOT NULL,
wys_obrazu MEDIUMINT UNSIGNED NOT NULL,
wielkosc_obrazu INT UNSIGNED NOT NULL,
data_przeslania TIMESTAMP,
PRIMARY KEY (obraz_id),
INDEX (data_przeslania)
);



CREATE DATABASE filmy_db;
USE filmy_db;

CREATE TABLE rezyserzy(
rezyser_id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
imie VARCHAR(20),
nazwisko VARCHAR(40),
PRIMARY KEY (rezyser_id),
KEY nazwisko(nazwisko)
);


CREATE TABLE filmy (
film_id INT UNSIGNED NOT NULL AUTO_INCREMENT,
rezyser_id INT UNSIGNED NOT NULL,
tytul VARCHAR(100) NOT NULL,
rok_wydania YEAR NOT NULL,
PRIMARY KEY (film_id),
INDEX (rezyser_id),
INDEX (tytul),
INDEX (rok_wydania)
);

INSERT INTO rezyserzy 
(imie, nazwisko) 
VALUES 
('Wes', 'Anderson'),
('Joel', 'Coen'),
('Paul Thomas', 'Anderson'),
('Zach', 'Braff'),
('Curtis', 'Hanson'),
('Marty', 'Scorsese'),
('Miranda', 'July'),
('Steven', 'Soderbergh');


INSERT INTO filmy
(rezyser_id, tytul, rok_wydania)
VALUES 
(1, 'The Royal Tenebaums', 2001),
(1, 'Bottle Rocket', 1996),
(1, 'Rushmore', 1998),
(2, 'Blood Simple', 1984),
(2, 'Raising Arizona', 1987),
(2, 'Miller\'s Crossing', 1990),
(2, 'Fargo', 1996),
(2, 'The Big Lebowski', 1998),
(2, 'O Brother, Where Art Thou?', 2000),
(2, 'The Man Who Wasn\'t There', 2001),
(2, 'Intolerable Cruelty', 2003),
(3, 'Boogie Nights', 1997),
(3, 'Magnolia', 2000),
(3, 'Punch-Drunk Love', 2002),
(4, 'Garden State', 2004),
(5, 'L.A. Confidential', 1997),
(5, 'Wonder Boys', 2000);

