#!/usr/bin/perl -w

# Listing 12.4 - transfer_money.pl
# Skrypt pozwala na przesanie rodkw
# z jednego konta na inne.

# Doczenie bibliotek.
use strict;
use DBI;

# Deklaracja zmiennych:
my ($dbh, $sql, $sth, @row, $balance, $affected, $from, $to, $amount);

# Wywietlenie komunikatu.
print "Program pozwala wykona przelew.\n\n";
print "Konto (ID konta):\n";

# Podaczenie do bazy danych.
$dbh = DBI->connect("DBI:mysql:test:localhost", 'root', 'root', {RaiseError => 1});

# Wywietlenie kont i ich identyfikatorw.
$sql = "SELECT CONCAT(nazwisko, ', ', imie) AS Nazwa, id FROM konta ORDER BY nazwisko, imie ASC";
$sth = $dbh->prepare($sql);
$sth->execute();
while (@row = $sth->fetchrow_array()) {
  print "$row[0] ($row[1])\n";
}
$sth->finish();

# Pobranie danych od uytkownika.
print "\nPodaj numer konta RdOWEGO ";
$from = <STDIN>;
print "\nPodaj numer konta DOCELOWEGO ";
$to = <STDIN>;
print "\nPodaj KWOT przesyanych rodkw ";
$amount = <STDIN>;

# Kontrola poprawnoci danych wejciowych (pominita).

# Potwierdzenie, e na koncie jest wystarczajco duo pienidzy.
$sql = "SELECT stan FROM konta WHERE id=$from";
$sth = $dbh->prepare($sql);
$sth->execute();
$balance = $sth->fetchrow_array();
$sth->finish();
  
# Czy mamy wystarczajco duo pienidzy?
if ($balance >= $amount) { # Transakcja!

  # Otwarcie transakcji.
  $dbh->{'AutoCommit'} = 0;  

  # Zmniejszenie stanu.
  $affected = $dbh->do("UPDATE konta SET stan=(stan - $amount) WHERE id=$from");
  if ($affected == 1) { # OK!

    # Zwikszenie satnu.
    $affected = $dbh->do("UPDATE konta SET stan=(stan + $amount) WHERE id=$to");
    if ($affected == 1) { # Zatwierdzamy.
    
      $dbh->commit();
      print "\nTransakcja jest zakoczona! \n";
      
    } else { # Wycofanie.
    
      $dbh->rollback();
      print "\nWystpi bd! Transakcja jest wycofana. \n";
      
    }
      
  } else { # Pierwsza instrukcja UPDATE nie dziaa.
    
    # Anulowanie transakcji.
    $dbh->rollback();
    
    print "\nWystpi bd! Transakcja jest wycofana. \n";
      
  }

} else { # Brak rodkw!
  print "\nBrak rodkw! \n";
}

# Odczenie.
$dbh->disconnect;
