#!/usr/bin/perl -w

# Skrypt 8.3, 'show_tables.pl'
# Skrypt oczekuje podania bazy danych 
# jako argumentu wiersza polece i wywietla
# tabele z podanej bazy danych.

# Doczenie potrzebnych moduw.
use strict;
use DBI;

# W czasie wywoania skrypt pobiera jeden argument.
# Jest nim nazwa bazy danych.
my $database = $ARGV[0];

if (defined($database)) {

  # Podczenie do bazy danych.
  my $dbh = DBI->connect("DBI:mysql:$database:localhost", 'username', 'password', {RaiseError => 1});
  
  # Wykonanie zapytania.
  my $sth = $dbh->prepare('SHOW TABLES');
  
  if (defined($sth)) {
    $sth->execute();
    my @row;
    while (@row = $sth->fetchrow_array()) {
      print "$row[0]\n";
    }
  }
  $sth->finish();
  
  # Odczenie.
  $dbh->disconnect;
  
} else {
  print "Prosz poda nazw bazy danych jako argument tego skryptu! \n";
}
