# Przechowywanie obrazu jako danych binarnych w pojedynczym dokumencie.

require 'rubygems'
require 'mongo'

# Przygotowanie obiektu danych binarnych do wstawienia.
image_filename = File.join(File.dirname(__FILE__), "canyon-thumb.jpg")
image_data = File.open(image_filename).read
bson_image_data = BSON::Binary.new(image_data)
doc = {"name" => "monument-thumb.jpg",
       "data" => bson_image_data }

# Nawiązanie połączenia i wstawienie dokumentu.
@con  = Mongo::MongoClient.new
@thumbnails = @con['images']['thumbnails']
@image_id = @thumbnails.insert(doc)

# Odszukanie dokumentu i upewnienie się, że odpowiada oryginalnemu.
doc = @thumbnails.find_one({"_id" => @image_id})
if image_data == doc["data"].to_s
  puts "Przechowywany obraz jest identyczny z oryginalnym plikiem!"
end
