#!/bin/bash
set -e

echo
echo "##################################################"
echo "# MongoDB In Action Sharded Cluster Setup Script #"
echo "##################################################"
echo
echo Ten skrypt konfiguruje przykładowy klaster shardingu, jak przedstawiono
echo w rozdziale 11. książki MongoDB in Action Second Edition. Skrypt działa
echo jedynie w systemach UNIX. Przyjęto założenie o istnieniu katalogu o nazwie
echo \"data\" w katalogu bieżącym. Dlatego też przed uruchomieniem tego skryptu
echo wydaj poniższe polecenie:
echo
echo mkdir ./data
echo
echo Wszystkie procesy mongo możesz zamknąć za pomocą następującego polecenia:
echo
echo killall mongod mongos
echo
echo Aby pozbyć się użytych danych, po prostu usuń katalog "data".
echo

# UWAGA: Wszystkie polecenia używają opcji "--eval", aby powłoka mongo była
# opakowana w "printjson". To nie jest konieczne podczas użycia powłoki w trybie
# interaktywnym, ponieważ wartości zwrotne poleceń są wyświetlane automatycznie.

# Nazwa hosta komputera lokalnego, w którym będzie działał klaster. Jeżeli to
# nie działa, spróbuj zmienić na "localhost".
if [ -z $HOSTNAME ]
then
    HOSTNAME=`hostname`
fi



echo
echo "########################"
echo "# Konfiguracja Shardów #"
echo "########################"
echo



echo Utworzenie wszystkich katalogów danych dla węzłów w zbiorze replik shardu A.
mkdir ./data/rs-a-1
mkdir ./data/rs-a-2
mkdir ./data/rs-a-3

echo Utworzenie wszystkich katalogów danych dla węzłów w zbiorze replik shardu B.
mkdir ./data/rs-b-1
mkdir ./data/rs-b-2
mkdir ./data/rs-b-3



echo Uruchomienie wszystkich węzłów mongod w zbiorze replik shardu A.
mongod --shardsvr --replSet shard-a --dbpath ./data/rs-a-1 --port 30000 \
       --logpath ./data/rs-a-1.log --fork
mongod --shardsvr --replSet shard-a --dbpath ./data/rs-a-2 --port 30001 \
       --logpath ./data/rs-a-2.log --fork
mongod --shardsvr --replSet shard-a --dbpath ./data/rs-a-3 --port 30002 \
       --logpath ./data/rs-a-3.log --fork

echo Uruchomienie wszystkich węzłów mongod w zbiorze replik shardu B.
mongod --shardsvr --replSet shard-b --dbpath ./data/rs-b-1 --port 30100 \
       --logpath ./data/rs-b-1.log --fork
mongod --shardsvr --replSet shard-b --dbpath ./data/rs-b-2 --port 30101 \
       --logpath ./data/rs-b-2.log --fork
mongod --shardsvr --replSet shard-b --dbpath ./data/rs-b-3 --port 30102 \
       --logpath ./data/rs-b-3.log --fork



echo Inicjalizacja zbioru replik shardu A.
mongo $HOSTNAME:30000 --eval "printjson(rs.initiate())"
echo Oczekiwanie na zakończenie inicjalizacji.
sleep 60
echo Dodanie węzła danych do zbioru replik.
mongo $HOSTNAME:30000 --eval "printjson(rs.add(\"$HOSTNAME:30001\"))"
echo Dodanie arbitra do zbioru replik.
mongo $HOSTNAME:30000 --eval "printjson(rs.addArb(\"$HOSTNAME:30002\"))"

echo Inicjalizacja zbioru replik shardu B.
mongo $HOSTNAME:30100 --eval "printjson(rs.initiate())"
echoOczekiwanie na zakończenie inicjalizacji.
sleep 60
echo Dodanie węzła danych do zbioru replik.
mongo $HOSTNAME:30100 --eval "printjson(rs.add(\"$HOSTNAME:30101\"))"
echo Dodanie arbitra do zbioru replik.
mongo $HOSTNAME:30100 --eval "printjson(rs.addArb(\"$HOSTNAME:30102\"))"



echo
echo "#######################################"
echo "# Przygotowanie serwerów konfiguracji #"
echo "#######################################"
echo



echo Utworzenie wszystkich katalogów danych dla węzłów serwerów konfiguracji.
mkdir ./data/config-1
mkdir ./data/config-2
mkdir ./data/config-3



echo Uruchomienie wszystkich węzłów mongod w węzłach serwerów konfiguracji.
mongod --configsvr --dbpath ./data/config-1 --port 27019 \
       --logpath ./data/config-1.log --fork
mongod --configsvr --dbpath ./data/config-2 --port 27020 \
       --logpath ./data/config-2.log --fork
mongod --configsvr --dbpath ./data/config-3 --port 27021 \
       --logpath ./data/config-3.log --fork
echo Oczekiwanie na pełne uruchomienie serwerów konfiguracji.
sleep 60



echo
echo "###############################"
echo "# Konfiguracja routera mongos #"
echo "###############################"
echo



echo Uruchomienie procesu routera mongos.
mongos --configdb $HOSTNAME:27019,$HOSTNAME:27020,$HOSTNAME:27021 \
       --logpath ./data/mongos.log --fork --port 40000



echo
echo "#########################"
echo "# Inicjalizacja klastra #"
echo "#########################"
echo



echo Dodanie shardu A do klastra.
mongo $HOSTNAME:40000 \
    --eval "printjson(sh.addShard(\"shard-a/$HOSTNAME:30000,$HOSTNAME:30001\"))"

echo Dodanie shardu B do klastra.
mongo $HOSTNAME:40000 \
    --eval "printjson(sh.addShard(\"shard-b/$HOSTNAME:30100,$HOSTNAME:30101\"))"
