

// 6.5  Wydajność działania potoku agregacji
// listing 6.3

db.numbers.find({num: {"$gt": 199995 }}).explain()

//    /* Powinieneś otrzymać wynik:
//
//     > db.numbers.find({num: {"$gt": 199995 }}).explain()
//     {
//         "cursor" : "BasicCursor",
//         "isMultiKey" : false,
//         "n" : 0,
//         "nscannedObjects" : 0,
//         "nscanned" : 0,
//         "nscannedObjectsAllPlans" : 0,
//         "nscannedAllPlans" : 0,
//         "scanAndOrder" : false,
//         "indexOnly" : false,
//         "nYields" : 0,
//         "nChunkSkips" : 0,
//         "millis" : 0,
//         "server" : "D830J:27017"
//     }
//
//     */

// listing 6.4

// Upewnij się, że będzie użyty indeks.
db.reviews.ensureIndex( { product_id: 1 } )

product  = db.products.findOne({'slug': 'taczka-9092'})

countsByRating = db.reviews.aggregate([
    {$match : {'product_id': product['_id']}},
    {$group : { _id:'$rating',
        count:{$sum:1}}}
],{explain:true})

//    /* Powinieneś otrzymać wynik:
//    > countsByRating = db.reviews.aggregate([
//        ...  {$match : {'product_id': product['_id']}},
//    ...  {$group : { _id:'$rating',
//    ...            count:{$sum:1}}}
//    ... ],{explain:true})
//    {
//        "stages" : [
//        {
//            "$cursor" : {
//                "query" : {
//                    "product_id" : ObjectId("4c4b1476238d3b4dd5003981")
//                },
//                "fields" : {
//                    "rating" : 1,
//                    "_id" : 0
//                },
//                "plan" : {
//                    "cursor" : "BtreeCursor ",
//                    "isMultiKey" : false,
//                    "scanAndOrder" : false,
//                    "indexBounds" : {
//                        "product_id" : [
//                            [
//                                ObjectId("4c4b1476238d3b4dd5003981"),
//                                ObjectId("4c4b1476238d3b4dd5003981")
//                            ]
//                        ]
//                    },
//                    "allPlans" : [
//                        ...
//    ]
//    }
//    }
//    },
//    {
//        "$group" : {
//        "_id" : "$rating",
//            "count" : {
//            "$sum" : {
//                "$const" : 1
//            }
//        }
//    }
//    }
//    ],
//    "ok" : 1
//    }
//
//     */

// Przykład użycia opcji allowDiskUse.
db.orders.aggregate([
    {$match: {purchase_data: {$gte: new Date(2010, 0, 1)}}},
    {$group: {
        _id: {year : {$year :'$purchase_data'},
            month: {$month :'$purchase_data'}},
        count: {$sum:1},
        total: {$sum:'$sub_total'}}},
    {$sort: {_id:-1}}
], {allowDiskUse:true});

// Przykład użycia opcji cursor w agregacji.
product  = db.products.findOne({'slug': 'taczka-9092'})
countsByRating = db.reviews.aggregate([
    {$match : {'product_id': product['_id']}},
    {$group : { _id:'$rating',
        count:{$sum:1}}}
],{cursor:{}})



