// Tylko jedno pole.

// ZOBACZ TAKŻE: sekcja 7.2.2 dotycząca tworzenia i usuwania indeksów.


// W przypadku BRAKU nazwy.
db.books.ensureIndex(           
    {title: 'text',
     shortDescription: 'text',
     longDescription: 'text',
     authors: 'text',
     categories: 'text'},
     
    {weights:
        {title: 10,
         shortDescription: 1,
         longDescription:1,
         authors: 1,
         categories: 5}
     }
);

// Spójrz na indeks.
// 1. ilość miejsca
// 2. długa nazwa indeksu

db.books.stats()

//    /*  listing 9.2
//
//    > db.books.stats()
//    {
//            "ns" : "catalog.books",
//            "count" : 431,
//            "size" : 772368,
//            "avgObjSize" : 1792,
//            "storageSize" : 2793472,
//            "numExtents" : 5,
//            "nindexes" : 2,
//            "lastExtentSize" : 2097152,
//            "paddingFactor" : 1,
//            "systemFlags" : 0,
//            "userFlags" : 1,
//            "totalIndexSize" : 858480,
//            "indexSizes" : {
//                    "_id_" : 24528,
//                    "title_text_shortDescription_text_longDescription_text_authors_text_categories_text" : 833952
//            },
//            "ok" : 1
//    }
//    */


// TERAZ przygotuj nazwę na podstawie indeksowanych pól.
// W omawianym przykładzie:

// '$**': 'text'

db.books.dropIndex('title_text_shortDescription_text_longDescription_text_authors_text_categories_text')

// OSTRZEŻENIE: nazwy mogą być całkiem długie: 82 znaki, maksimum wynosi 128 (łącznie z nazwą bazy danych itd.).
//   po dodaniu wszystkiego (nazwa bazy danych + kolekcji) mamy 96 znaki:
//         catalog.books.title_text_shortDescription_text_longDescription_text_authors_text_categories_text
//
// Dobra praktyka: zdefiniowanie nazwy (patrz następny przykład).

// Użycie znaku wieloznacznego,
// a także określenie nazwy indeksu.
db.books.ensureIndex(           
    {'$**': 'text'},
     
    {weights:
        {title: 10,
         categories: 5},

     name : 'books_text_index'
    }
);

// ***** UWAGI: 
// 1. waga kategorii i tytułów jest określena na podstawie kilku słów w podanych polach;
// 2. po utworzeniu indeksu nie można zmienić tej wagi, konieczne jest usunięcie indeksu i jego ponowne utworzenie.
// **************

//    /* Wynik.
//
//     > db.books.ensureIndex(
//     ...     {'$**': 'text'},
//     ...
//     ...     {weights:
//     ...         {title: 10,
//     ...          categories: 5},
//     ...
//     ...      name : 'books_text_index'
//     ...     }
//     ... );
//     {
//     "createdCollectionAutomatically" : false,
//     "numIndexesBefore" : 1,
//     "numIndexesAfter" : 2,
//     "ok" : 1
//     }
//
//     */

// *****************************************************
// Use below to compare with indexes in chapter 8
// *****************************************************

// W celu wyświetlenia indeksów łącznie z nazwą.
db.books.getIndexes()

//    /* Wynik.
//    > db.books.getIndexes()
//        [
//        {
//            "v" : 1,
//            "key" : {
//                "_id" : 1
//            },
//            "name" : "_id_",
//            "ns" : "catalog.books"
//        },
//        {
//            "v" : 1,
//            "key" : {
//                "_fts" : "text",
//                "_ftsx" : 1
//            },
//            "name" : "books_text_index",
//            "ns" : "catalog.books",
//            "weights" : {
//                "$**" : 1,
//                "categories" : 5,
//                "title" : 10
//            },
//            "default_language" : "english",
//            "language_override" : "language",
//            "textIndexVersion" : 2
//        }
//        ]
//
//    */

// Wyszukanie nazwy indeksu itd.
db.books.stats()

// Explain default_language, language_override
//    /* Sprawdzenie wielkości indeksu tekstowego.
//    > db.books.stats()
//    {
//        "ns" : "catalog.books",
//        "count" : 431,
//        "size" : 769552,
//        "avgObjSize" : 1785,
//        "storageSize" : 2793472,
//        "numExtents" : 5,
//        "nindexes" : 2,
//        "lastExtentSize" : 2097152,
//        "paddingFactor" : 1,
//        "systemFlags" : 0,
//        "userFlags" : 1,
//        "totalIndexSize" : 1005648,
//        "indexSizes" : {
//            "_id_" : 24528,
//            "books_text_index" : 981120
//    },
//        "ok" : 1
//    }
//    */


//******************************************
// UWAGA: ten indeks jest większy od danych
//   -  "books_text_index" : 981120  kontra   "size" : 769552,
//
// To zrozumiałe, o ile indeksowany jest cały tekst:
// - konieczne jest utworzenie elementu indeksu dla każdego słowa,
//     - mniej słów stop-listy i 
//     - mniej stemmingu? (który może być krótszy - script kontra scripting).
// 

