// 7.1

// Modyfikacja przez zastąpienie.

// **************  Wstawienie danych.
db.users.insert(
    {  _id: ObjectId("4c4b1476238d3b4dd5003981"),
      username: "kbanker",
      email: "kylebanker@gmail.com",
      first_name: "Kyle",
      last_name: "Banker",
      hashed_password: "bd1cfa194c3a603e7186780824b04419",
      addresses: [
        {
          name: "work",
          street: "1 E. 23rd Street",
          city: "Nowy Jork",
          state: "NY",
          zip: 10010
        }
      ]
    }
)

// ******* Uaktualnienie adresu e-mail.

user_id = ObjectId("4c4b1476238d3b4dd5003981")
doc = db.users.findOne({_id: user_id})
doc['email'] = 'mongodb-user@mongodb.com'
print('updating ' + user_id)
db.users.update({_id: user_id}, doc)

/* Wynik.
WriteResult({ "nMatched" : 1, "nUpserted" : 0, "nModified" : 1 })
*/

// Sprawdzenie modyfikacji.
db.users.findOne({_id: ObjectId("4c4b1476238d3b4dd5003981")})

/* Wynik.

> db.users.findOne({_id: ObjectId("4c4b1476238d3b4dd5003981")})
{
        "_id" : ObjectId("4c4b1476238d3b4dd5003981"),
        "username" : "kbanker",
        "email" : "mongodb-user@mongodb.com",
        "first_name" : "Kyle",
        "last_name" : "Banker",
        "hashed_password" : "bd1cfa194c3a603e7186780824b04419",
        "addresses" : [
                {
                        "name" : "work",
                        "street" : "1 E. 23rd Street",
                        "city" : "Nowy Jork",
                        "state" : "NY",
                        "zip" : 10010
                }
        ]
}

*/

// ******************** Modyfikacja za pomocą operatora.
user_id = ObjectId("4c4b1476238d3b4dd5003981")
db.users.update({_id: user_id}, 
  {$set: {email: 'mongodb-user2@mongodb.com'}})
  
/* Wynik 
WriteResult({ "nMatched" : 1, "nUpserted" : 0, "nModified" : 1 })
*/

// Sprawdzenie modyfikacji.
db.users.findOne({_id: ObjectId("4c4b1476238d3b4dd5003981")},{email:1})

/* Wynik.
{
        "_id" : ObjectId("4c4b1476238d3b4dd5003981"),
        "email" : "mongodb-user2@mongodb.com"
}
*/

// ************  Z uwagi dotyczącej składni - uaktualnienia kontra zapytania.

db.products.update({}, {$addToSet: {tags: 'zielony'}})

db.products.update({price: {$lte: 10}}, 
   {$addToSet: {tags: 'tani'}})


// ******* Porównanie obu metod.
product_id = ObjectId("4c4b1476238d3b4dd5003982")
doc = db.products.findOne({_id: product_id})
doc['total_reviews'] += 1       // Dodanie 1 do wartości total_reviews.
db.products.update({_id: product_id}, doc)

/* Wynik.
WriteResult({ "nMatched" : 1, "nUpserted" : 0, "nModified" : 1 })
*/

// Sprawdzenie wyniku.
db.products.findOne({_id: product_id},{total_reviews:1})

// Teraz używamy inkrementacji zamiast modyfikacji programu.
product_id = ObjectId("4c4b1476238d3b4dd5003982")
db.products.update({_id: product_id}, {$inc: {total_reviews: 1}})

// Wynik: WriteResult({ "nMatched" : 1, "nUpserted" : 0, "nModified" : 1 })

// Sprawdzenie wyniku.
db.products.findOne({_id: product_id},{total_reviews:1})
