#
# ******** Polecenia z podrozdziału 3.1, które mogą być wydane w irb.
#

# W przypadku ich wykonania z pliku potrzebna jest poniższa konfiguracja.

require 'rubygems'
require 'mongo'
$con   = Mongo::Connection.new
$db    = $con['tutorial']
$users = $db['users']
puts 'connected!'

# W celu usunięcia WSZYSTKICH użytkowników - w przypadku, gdy polecenia są
# wielokrotnie wykonywane z poziomu pliku.
$users.drop()

#
#   ************ Poniższe polecenie może być wykonane w powłoce interaktywnej 
#                języka Ruby (irb) po użyciu:
#
#        > irb -r ./connect.rb
#

# Część 1 - wstawienie użytkownika knuth.

id = $users.save({"lastname" => "knuth"})
$users.find_one({"_id" => id})


# Część 2 - wstawienie użytkowników smith i jones.

smith = {"last_name" => "smith", "age" => 30}
jones = {"last_name" => "jones", "age" => 40}

smith_id = $users.insert(smith)
jones_id = $users.insert(jones)

$users.find_one({"_id" => smith_id})
$users.find_one({"_id" => jones_id})

# Jeżeli polecenia wykonano z pliku - to będzie jedyny otrzymany wynik.
p $users.find_one({"_id" => smith_id})

# Przykłady wyszukiwania.
$users.find({"last_name" => "smith"})
$users.find({"age" => {"$gt" => 30}})


# Użycie kursora.
cursor = $users.find({"age" => {"$gt" => 30}})
cursor.each do |doc|
  puts doc["last_name"]
end

# Podejście alternatywne, bardziej neutralne dla języka.
cursor = $users.find({"age" => {"$gt" => 30}})
while doc = cursor.next
  puts doc["last_name"]
end

#
# ************* 3.1.4 Uaktualnienia i usunięcia.
#

$users.update({"last_name" => "smith"}, {"$set" => {"city" => "Chicago"}})

# Zobacz zmianę (uwaga: konieczne jest użycie '.next' na końcu polecenia,
# aby faktycznie wyświetlić pierwszy wynik z kursora.
$users.find({"last_name" => "smith"}).next

# Użycie właściwości multi o wartości true w celu przeprowadenia wielu uaktualnień.
$users.update({"last_name" => "smith"},
  {"$set" => {"city" => "Nowy Jork"}}, {:multi => true})

  
# Usunięcie wskazanych użytkowników.
$users.remove({"age" => {"$gte" => 40}})

# Usunięcie wszystkich użytkowników.
$users.remove


# 
#  ***************** 3.1.5 Polecenia bazy danych.
#

# Lista baz danych.
$admin_db = $con['admin']
$admin_db.command({"listDatabases" => 1})

# Usunięcie kolekcji users wraz z indeksami itd.
db = $con['tutorial']
db.drop_collection('users')

# Oto inny sposób usunięcia kolekcji.
db.command({"drop" => "users"})

#
#  ******************** 3.2.1 Generowanie identyfikator obiektu
#

require 'mongo'
id =  BSON::ObjectId.from_string('4c291856238d3b19b2000001')
id.generation_time

jun_id = BSON::ObjectId.from_time(Time.utc(2013, 6, 1))
jul_id = BSON::ObjectId.from_time(Time.utc(2013, 7, 1))
$users.find({'_id' => {'$gte' => jun_id, '$lt' => jul_id}})


#
# ******************* 3.2.3 Przez sieć
#

$users.insert({"last_name" => "james"}, :w => 1)
