
// Podrozdział 6.4 Modyfikacja dokumentów.
db.users.aggregate([
    {$match: {username: 'kbanker'}},
    {$project: {name: {first:'$first_name',
                       last:'$last_name'}}
    }
]);

//    /* Powinieneś otrzymać wynik:
//
//
//     { "_id" : ObjectId("4c4b1476238d3b4dd5000001"),
//       "name" : { "first" : "Kyle", "last" : "Banker" } }
//
//     */


// 6.4.1 Funkcje ciągu tekstowego.
db.users.aggregate([
    {$match: {username: 'kbanker'}},
    {$project:
    {name: {$concat:['$first_name', ' ', '$last_name']},    // 1
        firstInitial: {$substr: ['$first_name',0,1]},          // 2
        usernameUpperCase: {$toUpper: '$username'}             // 3
    }
    }
]);

//    /*  Oczekiwane wyniki.
//
//     { "_id" : ObjectId("4c4b1476238d3b4dd5000001"),
//       "name" : "Kyle Banker",
//       "firstInitial" : "K",
//       "usernameUpperCase" : "KBANKER" }
//
//
//     */

// Dodatkowy przykład dla sekcji 6.4.1 oparty na funkcji $substr.

db.orders.aggregate([
    {$unwind: '$line_items'},
    {$project: {
        'line_items.name': 1, 
        orderQuantity: 
            {$substr:['$line_items.quantity',0,10]}}},       // A
    {$project: {
        orderSummary: 
            {$concat: ['$orderQuantity', ' ', '$line_items.name']}}} // B
])
// #A Konwersja ‘line_items.quantity’ na ciąg tekstowy.
// #B Wersja wykorzystująca konkatenację ciągu tekstowego w celu połączenia
// # liczby sztuk zamawianego produktu z jego nazwą.

/* Oczekiwane wyniki.

> db.orders.aggregate([
...     {$unwind: '$line_items'},
...     {$project: {
...         'line_items.name': 1,
...         orderQuantity:
...             {$substr:['$line_items.quantity',0,10]}}},       // A
...     {$project: {
...         orderSummary:
...             {$concat: ['$orderQuantity', ' ', '$line_items.name']}}} // B
... ])
{ "_id" : ObjectId("6a5b1476238d3b4dd5000048"), "orderSummary" : "1 Bardzo duża taczka" }
{ "_id" : ObjectId("6a5b1476238d3b4dd5000048"), "orderSummary" : "2 Gumowe rękawice robocze, kolor czarny" }
{ "_id" : ObjectId("6a5b1476238d3b4dd5000049"), "orderSummary" : "1 Bardzo duża taczka" }
{ "_id" : ObjectId("6a5b1476238d3b4dd5000050"), "orderSummary" : "1 Bardzo duża taczka" }
{ "_id" : ObjectId("6a5b1476238d3b4dd5000051"), "orderSummary" : "1 Bardzo duża taczka" }
{ "_id" : ObjectId("6a5b1476238d3b4dd5000052"), "orderSummary" : "1 Bardzo duża taczka" }

*/


// 6.4.2 Funkcje arytmetyczne.
// Brak przykładów.

// 6.4.3 Funkcje daty i godziny.
// Brak przykładów.

// 6.4.4 Funkcje logiczne.
// Brak przykładów.

// 6.4.5 Operatory zbioru.
// Mając poniższe produkty: 
{ "_id" : ObjectId("4c4b1476238d3b4dd5003981"), 
  "productName" : "Bardzo duża taczka",
  "tags" : [ "narzędzia", "ogród", "ziemia" ]}
  
{ "_id" : ObjectId("4c4b1476238d3b4dd5003982"),
  "productName" : "Gumowe rękawice robocze, kolor czarny",
  "tags" : [ "ogród" ]}

  // i zdefiniowany tag
  testSet1 = ['narzędzia']
  
// przykład użycia setUnion przedstawia się następująco:
  db.products.aggregate([
    {$project: 
        {productName: '$name', 
         tags:1, 
         setUnion: {$setUnion:['$tags',testSet1]},
       }
    }
])

// i wygeneruje poniższe dane wyjściowe:
{   "_id" : ObjectId("4c4b1476238d3b4dd5003981"),
    "productName" : "Bardzo duża taczka",
    "tags" : ["narzędzia", "ogród", "ziemia"],
    "setUnion" : ["ogród","narzędzia","ziemia"]
}

{   "_id" : ObjectId("4c4b1476238d3b4dd5003982"),
    "productName" : "Gumowe rękawice robocze, kolor czarny",
    "tags" : ["ogród"],
    "setUnion" : ["narzędzia", "ogród"]
}

// 6.4.6  Pozostałe funkcje.
db.orders.aggregate([
    {$project: {
        orderSummary: {
            $map: {
                input: '$line_items',
                as: 'item',
                in: {
                    descr: {$concat: [
                        {$substr:['$$item.quantity',0,10]},
                        ' ', '$$item.name']},
                    price: '$$item.pricing.sale'
                }
            }
        }}
    }, 
    {$limit: 2}
]).pretty()
