// Sekcja 6.4.3. Funkcje daty i godziny.

db.orders.aggregate([
    {$match: {purchase_data: {$gte: new Date(2010, 0, 1)}}},
    {$group: {
        _id: {year : {$year :'$purchase_data'},         // 1
            month: {$month :'$purchase_data'}},       // 2
        count: {$sum:1},
        total: {$sum:'$sub_total'}}},
    {$sort: {_id:-1}}
]);

//    /* Oczekiwane wyniki.
//     // UWAGA: zmodyfikowaliśmy wartość "month", aby pominąć pewne miesiące.
//
//     { "_id" : { "year" : 2014, "month" : 11 },
//     "count" : 1, "total" : 4897 }
//     { "_id" : { "year" : 2014, "month" : 10 },
//     "count" : 2, "total" : 11093 }
//     { "_id" : { "year" : 2014, "month" : 9 },
//     "count" : 1, "total" : 4897 }
//
//     */