/* Maksymalna długość parametrów tekstowych (włącznie z końcowym znakiem NULL). */
#define STRING_SIZE 100

/* Kody błędów zwracane przez rejestr. */
typedef enum
{
  OK,
  CANNOT_ADD_KEY
}RegError;

/* Uchwyt kluczy rejestru. */
typedef struct Key* RegKey;

/* Tworzy nowy klucz rejestru na podstawie podanego parametru 'key_name'
   (nie może on być równy NULL i może mieć maksymalnie STRING_SIZE znaków).
   Zwraca uchwyt do klucza lub NULL po wystąpieniu błędu. */
RegKey createKey(char* key_name);

/* Wiąże podany parametr 'value' (nie może on być równy NULL i może mieć 
   maksymalnie STRING_SIZE znaków) z kluczem 'key' (NIE MOŻE BYĆ RÓWNY NULL). */
void storeValue(RegKey key, char* value);
  
/* Udostępnia klucz 'key' (nie może być on równy NULL) do odczytu.
   Zwraca: 
   OK, jeśli nie wystąpiły błędy,
   CANNOT_ADD_KEY, jeśli rejestr jest pełny i nie można opublikować więcej kluczy. */
RegError releaseKey(RegKey key);
