#ifndef USER_H
#define USER_H

#include <stdbool.h>

#define MAX_SIZE 50

/* Zwraca true, jeśli podana nazwa użytkownika istnieje i 
   podane zostało hasło właściwe dla tego użytkownika. 
   W przeciwnym razie zwraca false. Wykrywa błędne
   dane wejściowe (łańcuch znaków NULL). */
bool authenticateUser(char* username, char* pwd);

typedef enum{
  USER_SUCCESSFULLY_ADDED,
  USER_ALREADY_EXISTS,
  USER_ADMINISTRATION_FULL
}ERROR_CODE;

/* Dodaje nowego użytkownika o podanej nazwie, 'username', i podanym haśle,
   'pwd' (w asercji sprawdzane są wartości NULL). Zwraca: 
   USER_SUCCESSFULLY_ADDED przy powodzeniu,
   USER_ALREADY_EXISTS, jeśli podana nazwa użytkownika już jest zajęta,
   USER_ADMINISTRATION_FULL, jeżeli nie można dodać kolejnych użytkowników. */
ERROR_CODE addUser(char* username, char* pwd);

typedef struct ITERATOR* ITERATOR;

/* Tworzy instancję iteratora. Zwraca NULL po wystąpieniu błędu. */
ITERATOR createIterator();

/* Pobiera następny element z instancji iteratora. */
char* getNextElement(ITERATOR iterator);

/* Usuwa instancję iteratora. */
void destroyIterator(ITERATOR iterator);

#endif

