;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Schemat podcze programowanego ukadu
;
;                 +----v----+
;           MCLR [| 1     40|] RB7 <- S1
;                [| 2     39|] 
;                [| 3     38|] 
;                [| 4     37|] 
;                [| 5     36|] 
;                [| 6     35|] 
;      D1 <- RA5 [| 7     34|] 
;                [| 8     33|] 
;                [| 9     32|] VDD
;                [|10     31|] VSS
;            VDD [|11     30|] 
;            VSS [|12     29|] 
;(20 MHz) / OSC1 [|13     28|]
;         \ OSC2 [|14     27|]
;                [|15     26|] 
;                [|16     25|] 
;                [|17     24|]
;                [|18     23|] 
;                [|19     22|] 
;                [|20     21|] 
;                 +---------+
;                 PIC16F877A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#include <p16F877a.inc>

;ustawienia bitw konfiguracyjnych
__CONFIG _CP_OFF&_WDT_OFF&_BODEN_OFF&_PWRTE_OFF&_HS_OSC&_WRT_OFF&_LVP_OFF&_CPD_OFF

;program
	banksel(ADCON1)				;przejd do banku rejestru ADCON1 (bank 1)
	movlw	0x06				;przelij warto 0x06 do rejestru W
	movwf	ADCON1				;zaaduj rejestr ADCON1 wartoci z W (linie cyfrowe)
	bcf		TRISA, 5			;linia RA5 wyjciowa
	bsf 	TRISB, 7			;linia RB7 wejciowa
	bcf 	OPTION_REG, 7		;wczenie wewntrznego pull-up dla linii portu B
	banksel(PORTA)				;przejd do banku rejestru PORTA (bank 0)
	
;ptla nieskoczona
petla:

	btfss	PORTB, 7			;pomi nast. instrukcj, jeli RB7 = 1
	goto	przycisk_nekany		;skocz do podprogramu obsugi przycisku nkanego
	btfsc	PORTB, 7			;pomi nast. instrukcj, jeli RB7 = 0
	goto	przycisk_bezrobotny	;skocz do podprogramu obsugi przycisku bezrobotnego
	
	goto 	petla

;podprogram obsugi przycisku nkanego, czyli wcinitego
przycisk_nekany:
	bsf		PORTA, 5			;zawie diod
	return						;powrt z podprogramu

;podprogram obsugi przycisku bezrobotnego
przycisk_bezrobotny:
	bcf		PORTA, 5			;zga diod
	return						;powrt z podprogramu

	end
