/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] RB7 -> LED Dp
                [| 2     39|] RB6 -> LED G
                [| 3     38|] RB5 -> LED F
                [| 4     37|] RB4 -> LED E
                [| 5     36|] RB3 -> LED D
                [| 6     35|] RB2 -> LED C
                [| 7     34|] RB1 -> LED B
                [| 8     33|] RB0 -> LED A
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|]
                [|18     23|] 
      W1 <- RD0 [|19     22|] RD3 -> W4
      W2 <- RD1 [|20     21|] RD2 -> W3
                 +---------+
                 PIC16F877A
***************************************************************/

//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000
#include <htc.h>

//oscylator szybszy od 10 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

void main()
{
	ADCON1 = 0x06;		//wyczenie linii analogowych 
                    	//(wszystkie linie cyfrowe)
	TRISB = 0;			//wszystkie linie portu B wyjciowe
	TRISD = 0;			//wszystkie linie portu D wyjciowe

	for(;;)				//ptla nieskoczona
	{
		PORTD = 0b00001110;	//wcz W1 (RD0 w stan logicznego 0)
							//W2, W3, W4 wyczone
		PORTB = 0b11111001;	//wywietl cyfr 1
		__delay_ms(5);		//zaczekaj 5 ms

		PORTD = 0b00001101;	//wcz W2 (RD1 w stan logicznego 0)
							//W1, W3, W4 wyczone
		PORTB = 0b10100100;	//wywietl cyfr 2
		__delay_ms(5);		//zaczekaj 5 ms

		PORTD = 0b00001011;	//wcz W3 (RD2 w stan logicznego 0)
							//W1, W2, W4 wyczone
		PORTB = 0b10110000;	//wywietl cyfr 3
		__delay_ms(5);		//zaczekaj 5 ms

		PORTD = 0b00000111;	//wcz W4 (RD3 w stan logicznego 0)
							//W1, W2, W3 wyczone
		PORTB = 0b10011001;	//wywietl cyfr 4
		__delay_ms(5);		//zaczekaj 5 ms
	}
}
