/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] 
                [| 2     39|] 
                [| 3     38|] 
                [| 4     37|] 
                [| 5     36|] 
                [| 6     35|] 
      D1 <- RA5 [| 7     34|] 
                [| 8     33|] 
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|]
                [|18     23|] 
                [|19     22|] 
                [|20     21|] 
                 +---------+
                 PIC16F877A
***************************************************************/

#include <htc.h>
//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000

//oscylator szybszy od 10 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

void main()
{
	ADCON1 = 0x06;	//wyczenie linii analogowych 
                    //(wszystkie linie cyfrowe)
	TRISA = 0;		//linie portu A wyjciowe

	for(;;)			//ptla nieskoczona
	{
		PORTA |= (1<<5);	//wcz lini 5.
		__delay_ms(500);	//czekaj 1/2 s
		PORTA &= ~(1<<5);	//wycz lini 5.
		__delay_ms(500);	//czekaj 1/2 s

	}
}
