;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;        Schemat podcze programowanego ukadu
;                       +----v----+
;                 MCLR [| 1     28|] VDD
;                      [| 2     27|] VSS
;                      [| 3     26|] 
;                      [| 4     25|] 
;                      [| 5     24|] 
;                      [| 6     23|] 
;                      [| 7     22|] 
;                  VSS [| 8     21|] 
;       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
;               \ OSCO [|10     19|] DISVREG
;                      [|11     18|] 
;                      [|12     17|] 
;                  VDD [|13     16|] RB7 -> D1
;                      [|14     15|] 
;                       +---------+
;                     PIC24FJ64GB002
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	.include "p24FJ64GB002.inc"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ustawienia bitw konfiguracyjnych
;1. 
;FWDTEN_OFF - Watchdog wyczony
;JTAGEN_OFF - JTAG wyczony
	config  __CONFIG1,	FWDTEN_OFF & JTAGEN_OFF
;2.
;FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
;POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
;PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
	config  __CONFIG2,	FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; definicje staych
	.equ	procesorek, 16000-6
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; deklaracje symboli globalnych
	.global __reset				;etykieta pierwszej linii kodu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; pocztek kodu
__reset:
	mov		#__SP_init, W15		;inicjalizacja wskanika stosu (adres pocztku stosu)
	mov		#__SPLIM_init, W0	;inicjalizacja SPLIM (adres graniczny stosu)
	mov		W0, SPLIM			;W0 -> SPLIM
	nop                         ;konieczna instrukcja nop
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; konfiguracja linii portu B
	bclr	TRISB, #7			;linia RB7 wyjciowa

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; nieskoczona ptla
petla:

	bset	LATB, #7			;RB7 = 1
	mov		#250, W1			;W1 <- 250
	rcall	Czekaj_ms			;czekaj 250 ms

	bclr	LATB, #7			;RB7 = 0
	mov		#250, W1			;W1 <- 250
	rcall	Czekaj_ms			;czekaj 250 ms

	bra		petla				;skok bezwarunkowy do etykiety ptla
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Czekaj_ms:
	mov		#procesorek, W2		;W2 <- FCPU-6
	repeat	W2					;powtrz W2 razy
	nop
	dec		W1, W1				;W1--
	bra		NZ, Czekaj_ms		;wr do ptli, jeli nie byo 0
	return						;powrt z podprogramu
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.end							;koniec programu
