/**************************************************************
        Schemat podcze programowanego ukadu
                       +----v----+
                 MCLR [| 1     28|] VDD
            W1 -> RA0 [| 2     27|] VSS
            W2 -> RA1 [| 3     26|] RP15 -> DB4        
            W3 -> RB0 [| 4     25|] RP14 -> DB5
            W4 -> RB1 [| 5     24|] RP13 -> DB6
            K1 <- RB2 [| 6     23|] 
            K2 <- RB3 [| 7     22|] RP11 -> DB7
                  VSS [| 8     21|] RP10 -> RS
       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
               \ OSCO [|10     19|] DISVREG
                      [|11     18|] RB9 -> EN
                      [|12     17|] 
                  VDD [|13     16|] RB7 -> K4 
            K3 <- RB5 [|14     15|] 
                       +---------+
                     PIC24FJ64GB002
***************************************************************/
#include <p24Fxxxx.h>
//definiujemy szybko oscylatora dla funkcji __delay_
#define FCY 16000000UL 
//biblioteka z funkcjami __delay_us i __delay_ms
#include <libpic30.h>
//dyrektywa zapewniajca zgodno z wczeniejsz konwencj zapisu danych makr
#define USE_AND_OR	
//biblioteka funckji i makr obsugi moduu RTCC
#include <rtcc.h>

//ustawienia bitw konfiguracyjnych
//1. 
//FWDTEN_OFF - Watchdog wyczony
//JTAGEN_OFF - JTAG wyczony
_CONFIG1(FWDTEN_OFF & JTAGEN_OFF)
//2.
//FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
//POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
//PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
_CONFIG2(FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2)
//4.
//RTCOSC_LPRC - modu RTCC taktowany zegarem wewntrznym
_CONFIG4(RTCOSC_LPRC)
//////////////////////////////////////
#define TRIS_RS_LCD   TRISBbits.TRISB10
#define TRIS_EN_LCD   TRISBbits.TRISB9
#define TRIS_DB4_LCD  TRISBbits.TRISB15
#define TRIS_DB5_LCD  TRISBbits.TRISB14
#define TRIS_DB6_LCD  TRISBbits.TRISB13
#define TRIS_DB7_LCD  TRISBbits.TRISB11

#define RS_LCD   LATBbits.LATB10
#define EN_LCD   LATBbits.LATB9
#define DB4_LCD  LATBbits.LATB15
#define DB5_LCD  LATBbits.LATB14
#define DB6_LCD  LATBbits.LATB13
#define DB7_LCD  LATBbits.LATB11

#include "lcd.h"
//////////////////////////////////////
#define TRIS_W1  TRISAbits.TRISA0
#define TRIS_W2  TRISAbits.TRISA1
#define TRIS_W3  TRISBbits.TRISB0
#define TRIS_W4  TRISBbits.TRISB1
#define TRIS_K1  TRISBbits.TRISB2
#define TRIS_K2  TRISBbits.TRISB3
#define TRIS_K3  TRISBbits.TRISB5
#define TRIS_K4  TRISBbits.TRISB7

#define PORT_W1  PORTAbits.RA0
#define PORT_W2  PORTAbits.RA1
#define PORT_W3  PORTBbits.RB0
#define PORT_W4  PORTBbits.RB1
#define PORT_K1  LATBbits.LATB2
#define PORT_K2  LATBbits.LATB3
#define PORT_K3  LATBbits.LATB5
#define PORT_K4  LATBbits.LATB7

#include "klawiatura.h"
//////////////////////////////////////
//struktury obsugi moduu RTCC
rtccTimeDate RtccTimeDate;
unsigned char sekunda_poprzednia;
unsigned char dzien_poprzedni;

//tablice znakowe dla funkcji LCD
char napis0[8] = "        ";
char napis1[] = "Data:";		//5 znakw
char napis2[] = "Czas:";		//5 znakw
//zmienna pomocnicza dla obsugi klawiatury
char znak;

void No_dawaj_ten_czas_na_LCD()
{
	//resetuj poprzednio wywietlany czas
	UstawKursorLCD(2, 7);		//wiersz 2 kolumna 7
	WyswietlLCD(napis0, 8);		//wywietl 8 spacji
	UstawKursorLCD(2, 7);		//wiersz 2 kolumna 7

	//wywietl dziesitki godziny 
	Wyslij_do_LCD(((RtccTimeDate.f.hour&0x70)>>4)+0x30);
	//wywietl jednoci godziny 
	Wyslij_do_LCD((RtccTimeDate.f.hour&0x0F)+0x30);
	//wywietl :
	Wyslij_do_LCD(':');
	//wywietl dziesitki minut 
	Wyslij_do_LCD(((RtccTimeDate.f.min&0x70)>>4)+0x30);
	//wywietl jednoci minut 
	Wyslij_do_LCD((RtccTimeDate.f.min&0x0F)+0x30);
	//wywietl :
	Wyslij_do_LCD(':');	
	//wywietl dziesitki sekund 
	Wyslij_do_LCD(((RtccTimeDate.f.sec&0x70)>>4)+0x30);
	//wywietl jednoci sekund 
	Wyslij_do_LCD((RtccTimeDate.f.sec&0x0F)+0x30);
}

void No_dawaj_ten_datownik_na_LCD()
{
	//resetuj poprzednio wywietlan dat
	UstawKursorLCD(1, 7);		//wiersz 1 kolumna 7
	WyswietlLCD(napis0, 8);		//wywietl 8 spacji
	UstawKursorLCD(1, 7);		//wiersz 1 kolumna 7

	//wywietl dziesitki dni 
	Wyslij_do_LCD(((RtccTimeDate.f.mday&0x30)>>4)+0x30);
	//wywietl jednoci dni 
	Wyslij_do_LCD((RtccTimeDate.f.mday&0x0F)+0x30);
	//wywietl -
	Wyslij_do_LCD('-');
	//wywietl dziesitki miesicy 
	Wyslij_do_LCD(((RtccTimeDate.f.mon&0x10)>>4)+0x30);
	//wywietl jednoci miesicy 
	Wyslij_do_LCD((RtccTimeDate.f.mon&0x0F)+0x30);
	//wywietl -20
	Wyslij_do_LCD('-');	
	Wyslij_do_LCD('2');
	Wyslij_do_LCD('0');
	//wywietl dziesitki lat 
	Wyslij_do_LCD(((RtccTimeDate.f.year&0xF0)>>4)+0x30);
	//wywietl jednoci lat 
	Wyslij_do_LCD((RtccTimeDate.f.year&0x0F)+0x30);
}

unsigned char BCD_plus(unsigned char x)
{
	static unsigned char x4, x0;
	x4 = (x>>4);
	x0 = (x&0x0F);
	x0++;
	if(x0>9)
	{
		x0 = 0;
		x4++;
	}
	if(x4>9) x4 = 0;
	return (x4<<4)|x0;
}

unsigned char BCD_minus(unsigned char x)
{
	static unsigned char x4, x0;
	x4 = (x>>4);
	x0 = (x&0x0F);
	x0--;
	if(x0>9)
	{
		x0 = 9;
		x4--;
	}
	if(x4>9) x4 = 9;
	return (x4<<4)|x0;
}

int main()
{
	/////////////////////////////////////////////////////
	AD1PCFGL = 0xFFFF;			//wszystkie linie cyfrowe

	/////////////////////////////////////////////////////
	//uruchomienie wywietlacz LCD///////////////////////
	WlaczLCD();					//inicjalizacja wywietlacza LCD
	WyswietlLCD(napis1, 5);		//wywietl napis "Data:"
	UstawKursorLCD(2, 1);		//wiersz 2 kolumna 1
	WyswietlLCD(napis2, 5);		//wywietl napis "Czas:"

	/////////////////////////////////////////////////////
	Wlacz_klawiature();			//inicjalizacja portw klawiatury

	/////////////////////////////////////////////////////
	//konfiguracja moduu RTCC///////////////////////////
	RtccInitClock();			//inicjalizacja moduu RTCC
	mRtccSetInt(0);				//wycz obsug przerwania RTCC
	RtccWrOn();            		//ustaw bit RTCWREN - zezwl na modyfikacj rejestrw   
	//ustawienia pocztkowe czasu i daty (01.07.2011, godzina 01.01.00)
	RtccTimeDate.f.hour = 1;
	RtccTimeDate.f.min =  1;
	RtccTimeDate.f.sec =  0;
	RtccTimeDate.f.mday = 1;
	RtccTimeDate.f.mon =  7;
	RtccTimeDate.f.year = 0x11;
	sekunda_poprzednia = 100;	//ta warto wymusi wywietlenie godziny
	dzien_poprzedni = 100;		//ta warto wymusi wywietlenie daty
	//zaaduj dane do rejestrw moduu
	RtccWriteTimeDate(&RtccTimeDate,0);
	mRtccOn();					//wcz modu RTCC
	/////////////////////////////////////////////////////

	for(;;)						//nieskoczona ptla
	{
		//odczytaj czas i dat z moduu RTCC
		RtccReadTimeDate(&RtccTimeDate);	
	
		if(sekunda_poprzednia != RtccTimeDate.f.sec)	
		//jeli czas si zmieni
		{	
			//wywietl czas
			No_dawaj_ten_czas_na_LCD();
			//zaaduj now warto sekundy
			sekunda_poprzednia = RtccTimeDate.f.sec;
		}
		if(dzien_poprzedni != RtccTimeDate.f.mday)	
		//jeli data si zmienia
		{	
			//wywietl dat
			No_dawaj_ten_datownik_na_LCD();
			//zaaduj now warto dnia
			dzien_poprzedni = RtccTimeDate.f.mday;
		}

		//sprawd klawiatur
		znak = Czekaj_na_klawisz();
		//jeli zosta wcinity przycisk, wykonaj akcj
		if(znak)
		{
			switch(znak)
			{
				case 1:			//inkrementuj dzie
					RtccTimeDate.f.mday = BCD_plus(RtccTimeDate.f.mday);
					break;
				case 5:			//dekrementuj dzie
					RtccTimeDate.f.mday = BCD_minus(RtccTimeDate.f.mday);
					break;
				case 2:			//inkrementuj miesic
					RtccTimeDate.f.mon = BCD_plus(RtccTimeDate.f.mon);
					break;
				case 6:			//dekrementuj miesic
					RtccTimeDate.f.mon = BCD_minus(RtccTimeDate.f.mon);
					break;
				case 3:			//inkrementuj rok
					RtccTimeDate.f.year = BCD_plus(RtccTimeDate.f.year);
					break;
				case 7:			//dekrementuj rok
					RtccTimeDate.f.year = BCD_minus(RtccTimeDate.f.year);
					break;
				case 9:			//inkrementuj godzin
					RtccTimeDate.f.hour = BCD_plus(RtccTimeDate.f.hour);
					break;
				case 13:		//dekrementuj godzin
					RtccTimeDate.f.hour = BCD_minus(RtccTimeDate.f.hour);
					break;
				case 10:		//inkrementuj minut
					RtccTimeDate.f.min = BCD_plus(RtccTimeDate.f.min);
					break;
				case 14:		//dekrementuj minut
					RtccTimeDate.f.min = BCD_minus(RtccTimeDate.f.min);
					break;
			}
			
			//zaaduj dane do rejestrw moduu
			RtccWriteTimeDate(&RtccTimeDate,0);
			sekunda_poprzednia = 100;	//wymu wywietlenie zmiany czasu
			dzien_poprzedni = 100;		//wymu wywietlenie zmiany daty
			__delay_ms(250);			//czas stabilizacji
		}
	}
}
