/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] 
                [| 2     39|] 
                [| 3     38|] 
                [| 4     37|] 
                [| 5     36|] 
                [| 6     35|] 
                [| 7     34|] 
                [| 8     33|] RB0/INT <- S1
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|]
                [|18     23|] 
      D1 <- RD0 [|19     22|] 
      D2 <- RD1 [|20     21|] 
                 +---------+
                 PIC16F877A
***************************************************************/

#include <htc.h>

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

//zmienne globalne (musz by widoczne w funkcji obsugi przerwania)
unsigned char licznik_D1, licznik_D2;

void main()
{
	TRISDbits.TRISD0 = 0;		//linia RD0 wyjciowa
	TRISDbits.TRISD1 = 0;		//linia RD1 wyjciowa
	PORTDbits.RD0 = 0;			//dioda D1 nie wieci
	PORTDbits.RD1 = 0;			//dioda D2 nie wieci

	//konfiguracja przerwania RB0/INT
	OPTION_REGbits.INTEDG = 0;	//reakcja na zbocze opadajce
	INTCONbits.INTE = 1;		//wcz przerwanie RB0/INT

	//konfiguracja przerwania moduu Timer1
	TMR1H = 0x9E;				//TMR1 = 40536
	TMR1L = 0x58;				//(65536 - 40536)/5 * 25 = 125000
	//T1CONbits.T1CKPS1 = 0;	//brak preskalera
	//T1CONbits.T1CKPS0 = 0;	//brak preskalera
	PIE1bits.TMR1IE = 1;		//wcz przerwanie Timer1
	T1CONbits.TMR1ON = 1;		//wcz modu Timer1

	licznik_D1 = 0;				//wyzerowanie licznika diody D1
	licznik_D2 = 0;				//wyzerowanie licznika diody D2
	INTCONbits.PEIE = 1;		//wczenie przerwa urzdze peryferyjnych
	INTCONbits.GIE = 1;			//globalne wczenie przerwa

	for(;;)						//ptla nieskoczona
	{
	}
}

static void interrupt
knowania_przerwania(void)
{
	if(PIR1bits.TMR1IF == 1)	//przerwanie moduu Timer1
	{
		//obsu diod D1
		licznik_D1++;			//inkrementuj licznik
		if(licznik_D1>24)
		{
			PORTDbits.RD0 ^= 1;	//przecz stan diody D1
			licznik_D1 = 0;		//wyzeruj licznik
		}
		//obsu diod D2
		if(licznik_D2 > 0)
		{
			PORTDbits.RD1 = 1;	//zawie diod D1
			licznik_D2--;		//dekrementuj licznik
		}else PORTDbits.RD1 = 0;//inaczej zga diod D2
		//obsu modu Timer1
		TMR1H = 0x9E;			//TMR1 = 40536
		TMR1L = 0x58;			//(65536 - 40536)/5 * 25 = 125000
		PIR1bits.TMR1IF = 0;	//wyczy flag przerwania
	}
	if(INTCONbits.INTF == 1)	//przerwanie RB0/INT 
	{				
		licznik_D2 = 200;		//zawie diod D2 na czas 1 sekundy
		INTCONbits.INTF = 0;	//wyczy flag przerwania
	}
}

