/**************************************************************
   Schemat podcze programowanego ukadu

                 +----v----+
           MCLR [| 1     40|] RB7 -> D8
                [| 2     39|] RB6 -> D7
                [| 3     38|] RB5 -> D6
                [| 4     37|] RB4 -> D5
                [| 5     36|] RB3 -> D4
                [| 6     35|] RB2 -> D3
                [| 7     34|] RB1 -> D2
                [| 8     33|] RB0 -> D1
                [| 9     32|] VDD
                [|10     31|] VSS
            VDD [|11     30|] 
            VSS [|12     29|] 
(20 MHz) / OSC1 [|13     28|]
         \ OSC2 [|14     27|]
                [|15     26|] 
                [|16     25|] 
                [|17     24|] 
     SCL <- SCL [|18     23|] SDA <-> SDA
                [|19     22|] 
                [|20     21|] 
                 +---------+
                 PIC16F877A
***************************************************************/

void main()
{
 /////////////////////////////////////////////////////
 ADCON1 = 0x06;         //wyczenie linii analogowych
 /////////////////////////////////////////////////////
 //konfiguracja portu B
 TRISB = 0;             //cay port B wyjciowy (port z diodami LED)
 PORTB = 0;             //diody s zgaszone

 /////////////////////////////////////////////////////
 I2C1_Init(100000);     //inicjalizacja interfejsu I2C
 /////////////////////////////////////////////////////
 //zapisujemy bajt do pamici EEPROM
 I2C1_Start();          //wysyamy sygna START
 I2C1_Wr(0xA0);         //wysyamy pierwszy bajt (adres urzdzenia 0xA, strona 0)
 I2C1_Wr(0x00);         //wysyamy drugi bajt (adres w pamici EEPROM)
 I2C1_Wr(0x0F);         //dane do zapisania w komrce pamici
 I2C1_Stop();           //wysyamy sygna STOP

 Delay_ms(100);         //czekamy na zakoczenie procesu zapisywania

 /////////////////////////////////////////////////////
 //odczytujemy bajt z pamici EEPROM
 I2C1_Start();          //wysyamy sygna START
 I2C1_Wr(0xA0);         //wysyamy pierwszy bajt (adres urzdzenia 0xA0, najst. bity adresu = 0)
 I2C1_Wr(0x00);         //wysyamy drugi bajt (adres w pamici EEPROM)
 I2C1_Repeated_Start(); //powtarzamy sygna START
 I2C1_Wr(0xA1);         //wysyamy adres urzdzenia (0xA0) z ustawionym bitem W
 PORTB = I2C1_Rd(0u);   //odczytujemy dane, nie potwierdzamy AC
 I2C1_Stop();           //wysyamy sygna STOP

 /////////////////////////////////////////////////////
 //nieskoczona ptla
 for(;;);
}
