/**************************************************************
        Schemat podcze programowanego ukadu
                       +----v----+
                 MCLR [| 1     28|] VDD
                      [| 2     27|] VSS
                      [| 3     26|] RP15 -> SCK1OUT
            S1 -> RB0 [| 4     25|] RP14 -> SDO1
            S2 -> RB1 [| 5     24|] 
            S3 -> RB2 [| 6     23|] 
            S4 -> RB3 [| 7     22|] 
                  VSS [| 8     21|] 
       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
               \ OSCO [|10     19|] DISVREG
                      [|11     18|] RB9 -> D3
                      [|12     17|] RB8 -> D2
                  VDD [|13     16|] RB7 -> D1 
                      [|14     15|] 
                       +---------+
                     PIC24FJ64GB002
***************************************************************/
#include <p24Fxxxx.h>

//ustawienia bitw konfiguracyjnych
//1. 
//FWDTEN_OFF - Watchdog wyczony
//JTAGEN_OFF - JTAG wyczony
_CONFIG1(FWDTEN_OFF & JTAGEN_OFF)
//2.
//FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
//POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
//PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
_CONFIG2(FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2)

//funkcja tworzca opnienie o wielokrotno mikrosekund
//dla taktowania 32 MHz
void Czekaj_us(unsigned long int ile)
{
	//jednokrotne wykonanie ptli zajmuje 16 cykli (1 us)
	while(ile>0) 
	{
		ile--;
		asm("nop");		
		asm("nop");		
		asm("nop");		
		asm("nop");		
		asm("nop");	
		asm("nop");
	}
}

void StartSPI()
{
	//1. konfiguracja SPI1CON1 i SPI1CON2
	SPI1CON1bits.MSTEN = 1;		//tryb Master
	SPI1CON1bits.MODE16 = 0;	//dane 8-bitowe
	//2. ustawienie bitu SPIEN (wczenie moduu SPI1)
	SPI1STATbits.SPIEN = 1;	
}

unsigned char TransferSPI1(unsigned char dane)
{
    SPI1BUF = dane;				//zaaduj dane do bufora
    while(!SPI1STATbits.SPIRBF);//zaczekaj na zakoczenie operacji
    return SPI1BUF;    			//odczytaj dane
}


int main()
{
	AD1PCFG = 0xFFFF;			//wszystkie linie cyfrowe
	//konfiguracja linii portu B
	TRISBbits.TRISB0 = 1;		//linia RB0 wejciowa (S1)
	TRISBbits.TRISB1 = 1;		//linia RB1 wejciowa (S2)
	TRISBbits.TRISB2 = 1;		//linia RB2 wejciowa (S3)
	TRISBbits.TRISB3 = 1;		//linia RB3 wejciowa (S4)

	TRISBbits.TRISB7 = 0;		//linia RB7 wyjciowa (D1)
	TRISBbits.TRISB8 = 0;		//linia RB8 wyjciowa (D2)
	TRISBbits.TRISB9 = 0;		//linia RB9 wyjciowa (D3)

	//remapowanie linii portw dla interfejsu SPI
	//1. RP14 -> SDO1 (nr 7)
	RPOR7bits.RP14R = 7;
	//2. RP15 -> SCK1OUT (nr 8)
	RPOR7bits.RP15R = 8;
	
	StartSPI();					//uruchomienie moduu SPI

	for(;;)						//nieskoczona ptla
	{
		//sprawd przyciski
		if(PORTBbits.RB0 == 0)
		{
			LATBbits.LATB8 = 0;
			LATBbits.LATB9 = 0;
			TransferSPI1(1);
		}
		if(PORTBbits.RB1 == 0)
		{
			LATBbits.LATB8 = 1;
			LATBbits.LATB9 = 0;
			TransferSPI1(2);
		}
		if(PORTBbits.RB2 == 0)
		{
			LATBbits.LATB8 = 0;
			LATBbits.LATB9 = 1;
			TransferSPI1(3);
		}
		if(PORTBbits.RB3 == 0)
		{
			LATBbits.LATB8 = 1;
			LATBbits.LATB9 = 1;
			TransferSPI1(4);
		}
		//oczekiwanie 125 ms
		Czekaj_us(125000);
		//mruganie diody kontrolnej D1
		LATBbits.LATB7 ^= 1;
	}
}
