/**************************************************************
   Schemat podcze programowanego ukadu

                      +----v----+
                MCLR [| 1     40|] 
                     [| 2     39|] 
                     [| 3     38|] 
                     [| 4     37|] 
                     [| 5     36|] 
                     [| 6     35|] 
                     [| 7     34|] 
                     [| 8     33|] 
                     [| 9     32|] VDD
                     [|10     31|] VSS
                 VDD [|11     30|] 
                 VSS [|12     29|] 
     (20 MHz) / OSC1 [|13     28|]
              \ OSC2 [|14     27|]
                     [|15     26|] 
                     [|16     25|] 
        serwo <- RC2 [|17     24|] 
                     [|18     23|] 
                     [|19     22|] 
           S1 -> RD1 [|20     21|] RD2 -> S2
                      +---------+
                      PIC16F877A

***************************************************************/

//definiujemy szybko oscylatora dla funkcji __delay_
#define _XTAL_FREQ 20000000
#include <htc.h>

//oscylator 20 MHz (FOSC_HS)
//watchdog wyczony (WDTE_OFF)
//wyczone LVP (Low-Voltage ICSP Programming) (LVP_OFF)
__CONFIG(FOSC_HS & WDTE_OFF & LVP_OFF);

unsigned int czas_impulsu = 7500;

void main()
{
	ADCON1 = 0x06;			//wyczenie linii analogowych 
                    		//(wszystkie linie cyfrowe)
 	TRISCbits.TRISC2 = 0;	//linia RC2/CCP1 wyjciowa
	TRISDbits.TRISD1 = 1;	//linia RD1 z przyciskiem S1 wejciowa
	TRISDbits.TRISD2 = 1;	//linia RD2 z przyciskiem S2 wejciowa

	//konfiguracja moduu CCP1
  	CCP1CON = 0x0B; 		//(tryb Compare, Special Trigger Event)           							
  	PIE1bits.CCP1IE = 1;	//wcz przerwanie moduu CCP1
  	PIR1bits.CCP1IF = 0;	//wyzeruj flag przerwania
	PORTCbits.RC2 = 0;		//impuls niski
	CCPR1 = 0xFFFF;			//czas wypenienia = 13107 us

	//konfiguracja moduu Timer1
	PIE1bits.TMR1IE = 0;	//wycz przerwanie Timer1
	T1CONbits.TMR1ON = 1;	//wcz modu Timer1
	TMR1 = 0;				//wyzeruj rejestr TMR1

	INTCON = 0xC0;  		//wcz obsug przerwa

	for(;;)						//ptla nieskoczona
	{
		//sprawd przycisk S1
		if(PORTDbits.RD1 == 0)
		{
			czas_impulsu -= 10;	//zmniejsz kt
			if(czas_impulsu < 3500) czas_impulsu = 3500;
			__delay_ms(50);		//czekaj do czasu ustabilizowania impulsu
		}
		//sprawd przycisk S2
		if(PORTDbits.RD2 == 0)
		{
			czas_impulsu += 10;	//zwiksz kt
			if(czas_impulsu > 11500) czas_impulsu = 11500;
			__delay_ms(50);		//czekaj do czasu ustabilizowania impulsu
		}
	}
}

static void interrupt
knowania_przerwania(void)
{
	if (PIR1bits.CCP1IF)			//przerwanie CCP1
  	{
   		if(PORTCbits.RC2 == 0)		//jeli linia RC2/CCP1 bya wyzerowana
   		{
			PORTCbits.RC2 = 1;		//ustaw lini RC2/CCP1
			CCPR1 = czas_impulsu;	//czas impulsu
    	}
    	else 						//jeli linia RC2/CCP1 bya ustawiona
    	{
			PORTCbits.RC2 = 0;		//wyzeruj lini RC2/CCP1
			CCPR1 = 0xFFFF;			//czas wypenienia = 13107
    	}
		PIR1bits.CCP1IF = 0;		//wyzeruj flag przerwania (zezwl na nowe przerwanie)
	}
}
