# Galician (gl) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                     | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987º                                               | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5º                                                  | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987º                                               | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5º                                                  | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1º                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | T1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1º trimestre                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                        | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                   | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1º                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º                                                  | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | T1                                                  | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                                  | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1º trimestre                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2º trimestre                                        | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2º                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                                  | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | xul                                                 | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | febreiro                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | xullo                                               | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | f                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                   | Invalid Date             |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2º                                                  | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7º                                                  | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb                                                 | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | xul                                                 | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | febreiro                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | xullo                                               | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | f                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | j                                                   | Invalid Date             |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1º                                                  | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                                 | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1º                                                  | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48º                                                 | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11º                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28º                                                 | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42º                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365º                                                | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | lun                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | lun                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | lun                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                 | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | luns                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venres                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | l                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                   | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | lu                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                  | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1º                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                  | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | lun                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                 | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | luns                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venres                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | l                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | lu                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1º                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                  | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | lun                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                 | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | luns                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venres                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | l                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | lu                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                  | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1º                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5º                                                  | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | lun                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven                                                 | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | luns                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | venres                                              | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | l                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | v                                                   | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | lu                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                                  | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                   | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                  | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                                | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                   | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | da mañá                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da tardiña                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | da noite                                            | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | da mañá                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da tardiña                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | da noite                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | da mañá                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da tardiña                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | da noite                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | da mañá                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da tardiña                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | da noite                                            | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | da mañá                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | da tarde                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | da tardiña                                          | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | da noite                                            | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11º                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                                 | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11º                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                                 | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11º                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11º                                                 | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11º                                                 | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23º                                                 | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1º                                                  | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55º                                                 | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1º                                                  | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55º                                                 | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                          | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                          | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 feb 1987                                         | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453                                         | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 de febreiro 1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de maio 1453                                     | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | mércores, 11 de febreiro 1987                       | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | domingo, 29 de maio 1453                            | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                               | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                            | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                            | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                      | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                      | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                  | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                  | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987, 12:13                                   | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453, 23:59                                   | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 feb 1987, 12:13:14                               | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453, 23:59:59                               | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 de febreiro 1987 ás 12:13:14 GMT+0               | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 de maio 1453 ás 23:59:59 GMT+0                   | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | mércores, 11 de febreiro 1987 ás 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | domingo, 29 de maio 1453 ás 23:59:59 GMT+00:00      | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`      |
| ------------------------ | ------------------ | ---------------------- | ---------------------- |
| 2006-01-01T00:00:00.000Z | arredor de 6 anos  | arredor de 6 anos      | en arredor de 6 anos   |
| 2005-01-01T00:00:00.000Z | arredor de 5 anos  | arredor de 5 anos      | en arredor de 5 anos   |
| 2004-01-01T00:00:00.000Z | arredor de 4 anos  | arredor de 4 anos      | en arredor de 4 anos   |
| 2003-01-01T00:00:00.000Z | arredor de 3 anos  | arredor de 3 anos      | en arredor de 3 anos   |
| 2002-01-01T00:00:00.000Z | arredor de 2 anos  | arredor de 2 anos      | en arredor de 2 anos   |
| 2001-06-01T00:00:00.000Z | máis dun ano       | máis dun ano           | en máis dun ano        |
| 2001-02-01T00:00:00.000Z | arredor dun ano    | arredor dun ano        | en arredor dun ano     |
| 2001-01-01T00:00:00.000Z | arredor dun ano    | arredor dun ano        | en arredor dun ano     |
| 2000-06-01T00:00:00.000Z | 5 meses            | 5 meses                | en 5 meses             |
| 2000-03-01T00:00:00.000Z | 2 meses            | 2 meses                | en 2 meses             |
| 2000-02-01T00:00:00.000Z | arredor de 1 mes   | arredor de 1 mes       | en arredor de 1 mes    |
| 2000-01-15T00:00:00.000Z | 14 días            | 14 días                | en 14 días             |
| 2000-01-02T00:00:00.000Z | 1 día              | 1 día                  | en 1 día               |
| 2000-01-01T06:00:00.000Z | arredor de 6 horas | arredor de 6 horas     | en arredor de 6 horas  |
| 2000-01-01T01:00:00.000Z | arredor dunha hora | arredor dunha hora     | en arredor dunha hora  |
| 2000-01-01T00:45:00.000Z | arredor dunha hora | arredor dunha hora     | en arredor dunha hora  |
| 2000-01-01T00:30:00.000Z | 30 minutos         | 30 minutos             | en 30 minutos          |
| 2000-01-01T00:15:00.000Z | 15 minutos         | 15 minutos             | en 15 minutos          |
| 2000-01-01T00:01:00.000Z | 1 minuto           | 1 minuto               | en 1 minuto            |
| 2000-01-01T00:00:25.000Z | menos dun minuto   | medio minuto           | en menos dun minuto    |
| 2000-01-01T00:00:15.000Z | menos dun minuto   | menos de 20 segundos   | en menos dun minuto    |
| 2000-01-01T00:00:05.000Z | menos dun minuto   | menos de 10 segundos   | en menos dun minuto    |
| 2000-01-01T00:00:00.000Z | menos dun minuto   | menos de 5 segundos    | hai menos dun minuto   |
| 1999-12-31T23:59:55.000Z | menos dun minuto   | menos de 10 segundos   | hai menos dun minuto   |
| 1999-12-31T23:59:45.000Z | menos dun minuto   | menos de 20 segundos   | hai menos dun minuto   |
| 1999-12-31T23:59:35.000Z | menos dun minuto   | medio minuto           | hai menos dun minuto   |
| 1999-12-31T23:59:00.000Z | 1 minuto           | 1 minuto               | hai 1 minuto           |
| 1999-12-31T23:45:00.000Z | 15 minutos         | 15 minutos             | hai 15 minutos         |
| 1999-12-31T23:30:00.000Z | 30 minutos         | 30 minutos             | hai 30 minutos         |
| 1999-12-31T23:15:00.000Z | arredor dunha hora | arredor dunha hora     | hai arredor dunha hora |
| 1999-12-31T23:00:00.000Z | arredor dunha hora | arredor dunha hora     | hai arredor dunha hora |
| 1999-12-31T18:00:00.000Z | arredor de 6 horas | arredor de 6 horas     | hai arredor de 6 horas |
| 1999-12-30T00:00:00.000Z | 2 días             | 2 días                 | hai 2 días             |
| 1999-12-15T00:00:00.000Z | 17 días            | 17 días                | hai 17 días            |
| 1999-12-01T00:00:00.000Z | arredor de 1 mes   | arredor de 1 mes       | hai arredor de 1 mes   |
| 1999-11-01T00:00:00.000Z | 2 meses            | 2 meses                | hai 2 meses            |
| 1999-06-01T00:00:00.000Z | 7 meses            | 7 meses                | hai 7 meses            |
| 1999-01-01T00:00:00.000Z | arredor dun ano    | arredor dun ano        | hai arredor dun ano    |
| 1998-12-01T00:00:00.000Z | arredor dun ano    | arredor dun ano        | hai arredor dun ano    |
| 1998-06-01T00:00:00.000Z | máis dun ano       | máis dun ano           | hai máis dun ano       |
| 1998-01-01T00:00:00.000Z | arredor de 2 anos  | arredor de 2 anos      | hai arredor de 2 anos  |
| 1997-01-01T00:00:00.000Z | arredor de 3 anos  | arredor de 3 anos      | hai arredor de 3 anos  |
| 1996-01-01T00:00:00.000Z | arredor de 4 anos  | arredor de 4 anos      | hai arredor de 4 anos  |
| 1995-01-01T00:00:00.000Z | arredor de 5 anos  | arredor de 5 anos      | hai arredor de 5 anos  |
| 1994-01-01T00:00:00.000Z | arredor de 6 anos  | arredor de 6 anos      | hai arredor de 6 anos  |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 anos      | en 6 anos         | 52608 horas                    |
| 2005-01-01T00:00:00.000Z | 5 anos      | en 5 anos         | 43848 horas                    |
| 2004-01-01T00:00:00.000Z | 4 anos      | en 4 anos         | 35064 horas                    |
| 2003-01-01T00:00:00.000Z | 3 anos      | en 3 anos         | 26304 horas                    |
| 2002-01-01T00:00:00.000Z | 2 anos      | en 2 anos         | 17544 horas                    |
| 2001-06-01T00:00:00.000Z | 1 ano       | en 1 ano          | 12408 horas                    |
| 2001-02-01T00:00:00.000Z | 1 ano       | en 1 ano          | 9528 horas                     |
| 2001-01-01T00:00:00.000Z | 1 ano       | en 1 ano          | 8784 horas                     |
| 2000-06-01T00:00:00.000Z | 5 meses     | en 5 meses        | 3648 horas                     |
| 2000-03-01T00:00:00.000Z | 2 meses     | en 2 meses        | 1440 horas                     |
| 2000-02-01T00:00:00.000Z | 1 mes       | en 1 mes          | 744 horas                      |
| 2000-01-15T00:00:00.000Z | 14 días     | en 14 días        | 336 horas                      |
| 2000-01-02T00:00:00.000Z | 1 día       | en 1 día          | 24 horas                       |
| 2000-01-01T06:00:00.000Z | 6 horas     | en 6 horas        | 6 horas                        |
| 2000-01-01T01:00:00.000Z | 1 hora      | en 1 hora         | 1 hora                         |
| 2000-01-01T00:45:00.000Z | 45 minutos  | en 45 minutos     | 1 hora                         |
| 2000-01-01T00:30:00.000Z | 30 minutos  | en 30 minutos     | 1 hora                         |
| 2000-01-01T00:15:00.000Z | 15 minutos  | en 15 minutos     | 0 horas                        |
| 2000-01-01T00:01:00.000Z | 1 minuto    | en 1 minuto       | 0 horas                        |
| 2000-01-01T00:00:25.000Z | 25 segundos | en 25 segundos    | 0 horas                        |
| 2000-01-01T00:00:15.000Z | 15 segundos | en 15 segundos    | 0 horas                        |
| 2000-01-01T00:00:05.000Z | 5 segundos  | en 5 segundos     | 0 horas                        |
| 2000-01-01T00:00:00.000Z | 0 segundos  | hai 0 segundos    | 0 horas                        |
| 1999-12-31T23:59:55.000Z | 5 segundos  | hai 5 segundos    | 0 horas                        |
| 1999-12-31T23:59:45.000Z | 15 segundos | hai 15 segundos   | 0 horas                        |
| 1999-12-31T23:59:35.000Z | 25 segundos | hai 25 segundos   | 0 horas                        |
| 1999-12-31T23:59:00.000Z | 1 minuto    | hai 1 minuto      | 0 horas                        |
| 1999-12-31T23:45:00.000Z | 15 minutos  | hai 15 minutos    | 0 horas                        |
| 1999-12-31T23:30:00.000Z | 30 minutos  | hai 30 minutos    | 1 hora                         |
| 1999-12-31T23:15:00.000Z | 45 minutos  | hai 45 minutos    | 1 hora                         |
| 1999-12-31T23:00:00.000Z | 1 hora      | hai 1 hora        | 1 hora                         |
| 1999-12-31T18:00:00.000Z | 6 horas     | hai 6 horas       | 6 horas                        |
| 1999-12-30T00:00:00.000Z | 2 días      | hai 2 días        | 48 horas                       |
| 1999-12-15T00:00:00.000Z | 17 días     | hai 17 días       | 408 horas                      |
| 1999-12-01T00:00:00.000Z | 1 mes       | hai 1 mes         | 744 horas                      |
| 1999-11-01T00:00:00.000Z | 2 meses     | hai 2 meses       | 1464 horas                     |
| 1999-06-01T00:00:00.000Z | 7 meses     | hai 7 meses       | 5136 horas                     |
| 1999-01-01T00:00:00.000Z | 1 ano       | hai 1 ano         | 8760 horas                     |
| 1998-12-01T00:00:00.000Z | 1 ano       | hai 1 ano         | 9504 horas                     |
| 1998-06-01T00:00:00.000Z | 2 anos      | hai 2 anos        | 13896 horas                    |
| 1998-01-01T00:00:00.000Z | 2 anos      | hai 2 anos        | 17520 horas                    |
| 1997-01-01T00:00:00.000Z | 3 anos      | hai 3 anos        | 26280 horas                    |
| 1996-01-01T00:00:00.000Z | 4 anos      | hai 4 anos        | 35064 horas                    |
| 1995-01-01T00:00:00.000Z | 5 anos      | hai 5 anos        | 43824 horas                    |
| 1994-01-01T00:00:00.000Z | 6 anos      | hai 6 anos        | 52584 horas                    |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                 |
| ------------------------ | ---------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000             |
| 2000-01-05T00:00:00.000Z | mércores ás 00:00      |
| 2000-01-02T00:00:00.000Z | mañá ás 00:00          |
| 2000-01-01T00:00:00.000Z | hoxe ás 00:00          |
| 1999-12-31T00:00:00.000Z | onte ás 00:00          |
| 1999-12-27T00:00:00.000Z | o luns pasado ás 00:00 |
| 1999-12-21T00:00:00.000Z | 21/12/1999             |
