# Azerbaijani (az) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                          | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | -------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-nci                                                 | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-inci                                                   | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-nci                                                 | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-inci                                                   | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-inci                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-nci                                                    | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | K1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1ci kvartal                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ci kvartal                                              | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                        | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-inci                                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-nci                                                    | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | K1                                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | K2                                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1ci kvartal                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ci kvartal                                              | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2-nci                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-nci                                                    | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | Fev                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | İyul                                                     | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | Fevral                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | İyul                                                     | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | I                                                        | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2-nci                                                    | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-nci                                                    | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | Fev                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | İyul                                                     | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | Fevral                                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | İyul                                                     | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                                        | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | I                                                        | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-inci                                                   | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-inci                                                  | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-inci                                                   | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-inci                                                  | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11-inci                                                  | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-inci                                                  | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-nci                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-inci                                                 | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Baz.e                                                    | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cüm                                                      | 2019-02-13T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Baz.e                                                    | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cüm                                                      | 2019-02-13T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Baz.e                                                    | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cüm                                                      | 2019-02-13T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | Bazar ertəsi                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cümə                                                     | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-inci                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-inci                                                   | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Baz.e                                                    | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cüm                                                      | 2019-02-13T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | Bazar ertəsi                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cümə                                                     | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-inci                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-inci                                                   | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Baz.e                                                    | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cüm                                                      | 2019-02-13T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | Bazar ertəsi                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cümə                                                     | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-inci                                                   | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-inci                                                   | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Baz.e                                                    | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cüm                                                      | 2019-02-13T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Bazar ertəsi                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cümə                                                     | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | B.e                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C.                                                       | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | a.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | a                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                        | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                                       | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | a.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a.m.                                                     | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | a                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | p                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | p                                                        | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | a                                                        | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | səhər                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | gündüz                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | axşam                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | gecə                                                     | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | səhər                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | gündüz                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | axşam                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | gecə                                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | səhər                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | gündüz                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | axşam                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | gecə                                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | səhər                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | gündüz                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | axşam                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | gecə                                                     | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | səhər                                                    | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | gündüz                                                   | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | axşam                                                    | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | gecə                                                     | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-inci                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-inci                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-inci                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-üncü                                                  | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-inci                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-inci                                                  | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-inci                                                  | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-üncü                                                  | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-inci                                                   | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-inci                                                  | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-inci                                                   | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-inci                                                  | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                               | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 Fev 1987 il                                           | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May 1453 il                                           | Invalid Date             |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11-inci Fevral 1987 il                                   | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-uncu May 1453 il                                      | Invalid Date             |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | Çərşənbə, 11-inci Fevral 1987 il                         | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | Bazar, 29-uncu May 1453 il                               | Invalid Date             |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                    | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                    | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                                 | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                 | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                           | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                           | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                                       | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                                       | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                                        | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                                        | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 Fev 1987 il, 12:13:14                                 | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May 1453 il, 23:59:59                                 | Invalid Date             |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11-inci Fevral 1987 il 12:13:14 GMT+0 - də               | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29-uncu May 1453 il 23:59:59 GMT+0 - də                  | Invalid Date             |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | Çərşənbə, 11-inci Fevral 1987 il 12:13:14 GMT+00:00 - də | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | Bazar, 29-uncu May 1453 il 23:59:59 GMT+00:00 - də       | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result           | `includeSeconds: true` | `addSuffix: true`      |
| ------------------------ | ---------------- | ---------------------- | ---------------------- |
| 2006-01-01T00:00:00.000Z | təxminən 6 il    | təxminən 6 il          | təxminən 6 il əvvəl    |
| 2005-01-01T00:00:00.000Z | təxminən 5 il    | təxminən 5 il          | təxminən 5 il əvvəl    |
| 2004-01-01T00:00:00.000Z | təxminən 4 il    | təxminən 4 il          | təxminən 4 il əvvəl    |
| 2003-01-01T00:00:00.000Z | təxminən 3 il    | təxminən 3 il          | təxminən 3 il əvvəl    |
| 2002-01-01T00:00:00.000Z | təxminən 2 il    | təxminən 2 il          | təxminən 2 il əvvəl    |
| 2001-06-01T00:00:00.000Z | 1 ildən çox      | 1 ildən çox            | 1 ildən çox əvvəl      |
| 2001-02-01T00:00:00.000Z | təxminən 1 il    | təxminən 1 il          | təxminən 1 il əvvəl    |
| 2001-01-01T00:00:00.000Z | təxminən 1 il    | təxminən 1 il          | təxminən 1 il əvvəl    |
| 2000-06-01T00:00:00.000Z | 5 ay             | 5 ay                   | 5 ay əvvəl             |
| 2000-03-01T00:00:00.000Z | 2 ay             | 2 ay                   | 2 ay əvvəl             |
| 2000-02-01T00:00:00.000Z | təxminən 1 ay    | təxminən 1 ay          | təxminən 1 ay əvvəl    |
| 2000-01-15T00:00:00.000Z | 14 gün           | 14 gün                 | 14 gün əvvəl           |
| 2000-01-02T00:00:00.000Z | 1 gün            | 1 gün                  | 1 gün əvvəl            |
| 2000-01-01T06:00:00.000Z | təxminən 6 saat  | təxminən 6 saat        | təxminən 6 saat əvvəl  |
| 2000-01-01T01:00:00.000Z | təxminən 1 saat  | təxminən 1 saat        | təxminən 1 saat əvvəl  |
| 2000-01-01T00:45:00.000Z | təxminən 1 saat  | təxminən 1 saat        | təxminən 1 saat əvvəl  |
| 2000-01-01T00:30:00.000Z | 30 dəqiqə        | 30 dəqiqə              | 30 dəqiqə əvvəl        |
| 2000-01-01T00:15:00.000Z | 15 dəqiqə        | 15 dəqiqə              | 15 dəqiqə əvvəl        |
| 2000-01-01T00:01:00.000Z | bir dəqiqə       | bir dəqiqə             | bir dəqiqə əvvəl       |
| 2000-01-01T00:00:25.000Z | bir dəqiqədən az | yarım dəqiqə           | bir dəqiqədən az əvvəl |
| 2000-01-01T00:00:15.000Z | bir dəqiqədən az | 20 bir saniyədən az    | bir dəqiqədən az əvvəl |
| 2000-01-01T00:00:05.000Z | bir dəqiqədən az | 10 bir saniyədən az    | bir dəqiqədən az əvvəl |
| 2000-01-01T00:00:00.000Z | bir dəqiqədən az | 5 bir saniyədən az     | bir dəqiqədən az sonra |
| 1999-12-31T23:59:55.000Z | bir dəqiqədən az | 10 bir saniyədən az    | bir dəqiqədən az sonra |
| 1999-12-31T23:59:45.000Z | bir dəqiqədən az | 20 bir saniyədən az    | bir dəqiqədən az sonra |
| 1999-12-31T23:59:35.000Z | bir dəqiqədən az | yarım dəqiqə           | bir dəqiqədən az sonra |
| 1999-12-31T23:59:00.000Z | bir dəqiqə       | bir dəqiqə             | bir dəqiqə sonra       |
| 1999-12-31T23:45:00.000Z | 15 dəqiqə        | 15 dəqiqə              | 15 dəqiqə sonra        |
| 1999-12-31T23:30:00.000Z | 30 dəqiqə        | 30 dəqiqə              | 30 dəqiqə sonra        |
| 1999-12-31T23:15:00.000Z | təxminən 1 saat  | təxminən 1 saat        | təxminən 1 saat sonra  |
| 1999-12-31T23:00:00.000Z | təxminən 1 saat  | təxminən 1 saat        | təxminən 1 saat sonra  |
| 1999-12-31T18:00:00.000Z | təxminən 6 saat  | təxminən 6 saat        | təxminən 6 saat sonra  |
| 1999-12-30T00:00:00.000Z | 2 gün            | 2 gün                  | 2 gün sonra            |
| 1999-12-15T00:00:00.000Z | 17 gün           | 17 gün                 | 17 gün sonra           |
| 1999-12-01T00:00:00.000Z | təxminən 1 ay    | təxminən 1 ay          | təxminən 1 ay sonra    |
| 1999-11-01T00:00:00.000Z | 2 ay             | 2 ay                   | 2 ay sonra             |
| 1999-06-01T00:00:00.000Z | 7 ay             | 7 ay                   | 7 ay sonra             |
| 1999-01-01T00:00:00.000Z | təxminən 1 il    | təxminən 1 il          | təxminən 1 il sonra    |
| 1998-12-01T00:00:00.000Z | təxminən 1 il    | təxminən 1 il          | təxminən 1 il sonra    |
| 1998-06-01T00:00:00.000Z | 1 ildən çox      | 1 ildən çox            | 1 ildən çox sonra      |
| 1998-01-01T00:00:00.000Z | təxminən 2 il    | təxminən 2 il          | təxminən 2 il sonra    |
| 1997-01-01T00:00:00.000Z | təxminən 3 il    | təxminən 3 il          | təxminən 3 il sonra    |
| 1996-01-01T00:00:00.000Z | təxminən 4 il    | təxminən 4 il          | təxminən 4 il sonra    |
| 1995-01-01T00:00:00.000Z | təxminən 5 il    | təxminən 5 il          | təxminən 5 il sonra    |
| 1994-01-01T00:00:00.000Z | təxminən 6 il    | təxminən 6 il          | təxminən 6 il sonra    |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 il       | 6 il əvvəl        | 52608 saat                     |
| 2005-01-01T00:00:00.000Z | 5 il       | 5 il əvvəl        | 43848 saat                     |
| 2004-01-01T00:00:00.000Z | 4 il       | 4 il əvvəl        | 35064 saat                     |
| 2003-01-01T00:00:00.000Z | 3 il       | 3 il əvvəl        | 26304 saat                     |
| 2002-01-01T00:00:00.000Z | 2 il       | 2 il əvvəl        | 17544 saat                     |
| 2001-06-01T00:00:00.000Z | 1 il       | 1 il əvvəl        | 12408 saat                     |
| 2001-02-01T00:00:00.000Z | 1 il       | 1 il əvvəl        | 9528 saat                      |
| 2001-01-01T00:00:00.000Z | 1 il       | 1 il əvvəl        | 8784 saat                      |
| 2000-06-01T00:00:00.000Z | 5 ay       | 5 ay əvvəl        | 3648 saat                      |
| 2000-03-01T00:00:00.000Z | 2 ay       | 2 ay əvvəl        | 1440 saat                      |
| 2000-02-01T00:00:00.000Z | 1 ay       | 1 ay əvvəl        | 744 saat                       |
| 2000-01-15T00:00:00.000Z | 14 gün     | 14 gün əvvəl      | 336 saat                       |
| 2000-01-02T00:00:00.000Z | 1 gün      | 1 gün əvvəl       | 24 saat                        |
| 2000-01-01T06:00:00.000Z | 6 saat     | 6 saat əvvəl      | 6 saat                         |
| 2000-01-01T01:00:00.000Z | 1 saat     | 1 saat əvvəl      | 1 saat                         |
| 2000-01-01T00:45:00.000Z | 45 dəqiqə  | 45 dəqiqə əvvəl   | 1 saat                         |
| 2000-01-01T00:30:00.000Z | 30 dəqiqə  | 30 dəqiqə əvvəl   | 1 saat                         |
| 2000-01-01T00:15:00.000Z | 15 dəqiqə  | 15 dəqiqə əvvəl   | 0 saat                         |
| 2000-01-01T00:01:00.000Z | bir dəqiqə | bir dəqiqə əvvəl  | 0 saat                         |
| 2000-01-01T00:00:25.000Z | 25 saniyə  | 25 saniyə əvvəl   | 0 saat                         |
| 2000-01-01T00:00:15.000Z | 15 saniyə  | 15 saniyə əvvəl   | 0 saat                         |
| 2000-01-01T00:00:05.000Z | 5 saniyə   | 5 saniyə əvvəl    | 0 saat                         |
| 2000-01-01T00:00:00.000Z | 0 saniyə   | 0 saniyə sonra    | 0 saat                         |
| 1999-12-31T23:59:55.000Z | 5 saniyə   | 5 saniyə sonra    | 0 saat                         |
| 1999-12-31T23:59:45.000Z | 15 saniyə  | 15 saniyə sonra   | 0 saat                         |
| 1999-12-31T23:59:35.000Z | 25 saniyə  | 25 saniyə sonra   | 0 saat                         |
| 1999-12-31T23:59:00.000Z | bir dəqiqə | bir dəqiqə sonra  | 0 saat                         |
| 1999-12-31T23:45:00.000Z | 15 dəqiqə  | 15 dəqiqə sonra   | 0 saat                         |
| 1999-12-31T23:30:00.000Z | 30 dəqiqə  | 30 dəqiqə sonra   | 1 saat                         |
| 1999-12-31T23:15:00.000Z | 45 dəqiqə  | 45 dəqiqə sonra   | 1 saat                         |
| 1999-12-31T23:00:00.000Z | 1 saat     | 1 saat sonra      | 1 saat                         |
| 1999-12-31T18:00:00.000Z | 6 saat     | 6 saat sonra      | 6 saat                         |
| 1999-12-30T00:00:00.000Z | 2 gün      | 2 gün sonra       | 48 saat                        |
| 1999-12-15T00:00:00.000Z | 17 gün     | 17 gün sonra      | 408 saat                       |
| 1999-12-01T00:00:00.000Z | 1 ay       | 1 ay sonra        | 744 saat                       |
| 1999-11-01T00:00:00.000Z | 2 ay       | 2 ay sonra        | 1464 saat                      |
| 1999-06-01T00:00:00.000Z | 7 ay       | 7 ay sonra        | 5136 saat                      |
| 1999-01-01T00:00:00.000Z | 1 il       | 1 il sonra        | 8760 saat                      |
| 1998-12-01T00:00:00.000Z | 1 il       | 1 il sonra        | 9504 saat                      |
| 1998-06-01T00:00:00.000Z | 2 il       | 2 il sonra        | 13896 saat                     |
| 1998-01-01T00:00:00.000Z | 2 il       | 2 il sonra        | 17520 saat                     |
| 1997-01-01T00:00:00.000Z | 3 il       | 3 il sonra        | 26280 saat                     |
| 1996-01-01T00:00:00.000Z | 4 il       | 4 il sonra        | 35064 saat                     |
| 1995-01-01T00:00:00.000Z | 5 il       | 5 il sonra        | 43824 saat                     |
| 1994-01-01T00:00:00.000Z | 6 il       | 6 il sonra        | 52584 saat                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                        |
| ------------------------ | ----------------------------- |
| 2000-01-10T00:00:00.000Z | 10.01.2000                    |
| 2000-01-05T00:00:00.000Z | Çərşənbə 0:00 -də             |
| 2000-01-02T00:00:00.000Z | sabah 0:00 -də                |
| 2000-01-01T00:00:00.000Z | bugün 0:00 -də                |
| 1999-12-31T00:00:00.000Z | dünən 0:00 -də                |
| 1999-12-27T00:00:00.000Z | sonuncu Bazar ertəsi 0:00 -də |
| 1999-12-21T00:00:00.000Z | 21.12.1999                    |
