function unwrapExports (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function createCommonjsModule(fn, module) {
	return module = { exports: {} }, fn(module, module.exports), module.exports;
}

var singleSpaSvelte_1 = createCommonjsModule(function (module, exports) {

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = singleSpaSvelte;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var defaultOpts = {
  // wymagane opcje
  component: null,
  // opcje opcjonalne
  domElementGetter: null,
  props: {}
};

function singleSpaSvelte(userOpts) {
  if (_typeof(userOpts) !== "object") {
    throw new Error("single-spa-svelte requires a configuration object");
  }

  var opts = _objectSpread({}, defaultOpts, {}, userOpts);

  if (!opts.component) {
    throw new Error("single-spa-svelte must be passed opts.component");
  } // Współdzielony obiekt do przechowywania stanu załadowanych obiektów


  var mountedInstances = {};
  return {
    bootstrap: bootstrap.bind(null, opts, mountedInstances),
    mount: mount.bind(null, opts, mountedInstances),
    unmount: unmount.bind(null, opts, mountedInstances)
  };
}

function bootstrap(opts) {
  return Promise.resolve();
}

function mount(opts, mountedInstances, singleSpaProps) {
  var defaultOptKeys = Object.keys(defaultOpts);
  var svelteOpts = Object.keys(opts).reduce(function (object, key) {
    if (!defaultOptKeys.includes(key)) {
      object[key] = opts[key];
    }

    return object;
  }, {});
  return Promise.resolve().then(function () {
    var domElementGetter = chooseDomElementGetter(opts, singleSpaProps);
    var domElement = domElementGetter(); // Zob. https://svelte.dev/docs#Creating_a_component

    mountedInstances.instance = new opts.component(_objectSpread({}, svelteOpts, {
      target: domElement,
      props: Object.assign({}, singleSpaProps, opts.props)
    }));
  });
}

function unmount(opts, mountedInstances) {
  return Promise.resolve().then(function () {
    mountedInstances.instance.$destroy ? mountedInstances.instance.$destroy() : mountedInstances.instance.destroy();
  });
}

function chooseDomElementGetter(opts, props) {
  props = props && props.customProps ? props.customProps : props;

  if (props.domElement) {
    return function () {
      return props.domElement;
    };
  } else if (props.domElementGetter) {
    return props.domElementGetter;
  } else if (opts.domElementGetter) {
    return opts.domElementGetter;
  } else {
    return defaultDomElementGetter(props);
  }
}

function defaultDomElementGetter(props) {
  var appName = props.appName || props.name;

  if (!appName) {
    throw Error("single-spa-svelte was not given an application name as a prop, so it can't make a unique dom element container for the svelte application");
  }

  var htmlId = "single-spa-application:".concat(appName);
  return function defaultDomEl() {
    var domElement = document.getElementById(htmlId);

    if (!domElement) {
      domElement = document.createElement("div");
      domElement.id = htmlId;
      document.body.appendChild(domElement);
    }

    return domElement;
  };
}

});

var singleSpaSvelte = unwrapExports(singleSpaSvelte_1);

function noop() { }
function run(fn) {
    return fn();
}
function blank_object() {
    return Object.create(null);
}
function run_all(fns) {
    fns.forEach(run);
}
function is_function(thing) {
    return typeof thing === 'function';
}
function safe_not_equal(a, b) {
    return a != a ? b == b : a !== b || ((a && typeof a === 'object') || typeof a === 'function');
}

function append(target, node) {
    target.appendChild(node);
}
function insert(target, node, anchor) {
    target.insertBefore(node, anchor || null);
}
function detach(node) {
    node.parentNode.removeChild(node);
}
function element(name) {
    return document.createElement(name);
}
function text(data) {
    return document.createTextNode(data);
}
function space() {
    return text(' ');
}
function listen(node, event, handler, options) {
    node.addEventListener(event, handler, options);
    return () => node.removeEventListener(event, handler, options);
}
function attr(node, attribute, value) {
    if (value == null)
        node.removeAttribute(attribute);
    else if (node.getAttribute(attribute) !== value)
        node.setAttribute(attribute, value);
}
function children(element) {
    return Array.from(element.childNodes);
}

let current_component;
function set_current_component(component) {
    current_component = component;
}

const dirty_components = [];
const binding_callbacks = [];
const render_callbacks = [];
const flush_callbacks = [];
const resolved_promise = Promise.resolve();
let update_scheduled = false;
function schedule_update() {
    if (!update_scheduled) {
        update_scheduled = true;
        resolved_promise.then(flush);
    }
}
function add_render_callback(fn) {
    render_callbacks.push(fn);
}
let flushing = false;
const seen_callbacks = new Set();
function flush() {
    if (flushing)
        return;
    flushing = true;
    do {
        // najpierw wywołanie funkcji beforeUpdate
        // i aktualizacja komponentu
        for (let i = 0; i < dirty_components.length; i += 1) {
            const component = dirty_components[i];
            set_current_component(component);
            update(component.$$);
        }
        dirty_components.length = 0;
        while (binding_callbacks.length)
            binding_callbacks.pop()();
        // następnie, po aktualizacji, wywołanie
        // funkcji afterUpdate. Może to spowodować
        // falsze aktualizacje...
        for (let i = 0; i < render_callbacks.length; i += 1) {
            const callback = render_callbacks[i];
            if (!seen_callbacks.has(callback)) {
                // ...więc chronimy się przed nieskończonymi pętlami
                seen_callbacks.add(callback);
                callback();
            }
        }
        render_callbacks.length = 0;
    } while (dirty_components.length);
    while (flush_callbacks.length) {
        flush_callbacks.pop()();
    }
    update_scheduled = false;
    flushing = false;
    seen_callbacks.clear();
}
function update($$) {
    if ($$.fragment !== null) {
        $$.update();
        run_all($$.before_update);
        const dirty = $$.dirty;
        $$.dirty = [-1];
        $$.fragment && $$.fragment.p($$.ctx, dirty);
        $$.after_update.forEach(add_render_callback);
    }
}
const outroing = new Set();
function transition_in(block, local) {
    if (block && block.i) {
        outroing.delete(block);
        block.i(local);
    }
}
function mount_component(component, target, anchor) {
    const { fragment, on_mount, on_destroy, after_update } = component.$$;
    fragment && fragment.m(target, anchor);
    // onMount zachodzi przed pierwszym wywołaniem funkcji afterUpdate
    add_render_callback(() => {
        const new_on_destroy = on_mount.map(run).filter(is_function);
        if (on_destroy) {
            on_destroy.push(...new_on_destroy);
        }
        else {
            // Przypadek skrajny - komponent został natychmiast zniszczony,
            // najprawdopodobniej w wyniku inicjalizacij powiązania
            run_all(new_on_destroy);
        }
        component.$$.on_mount = [];
    });
    after_update.forEach(add_render_callback);
}
function destroy_component(component, detaching) {
    const $$ = component.$$;
    if ($$.fragment !== null) {
        run_all($$.on_destroy);
        $$.fragment && $$.fragment.d(detaching);
        // TODO: wynulowanie innych referencji, w tym component.$$ (ale trzeba
        // zachować końcowy stan?)
        $$.on_destroy = $$.fragment = null;
        $$.ctx = [];
    }
}
function make_dirty(component, i) {
    if (component.$$.dirty[0] === -1) {
        dirty_components.push(component);
        schedule_update();
        component.$$.dirty.fill(0);
    }
    component.$$.dirty[(i / 31) | 0] |= (1 << (i % 31));
}
function init(component, options, instance, create_fragment, not_equal, props, dirty = [-1]) {
    const parent_component = current_component;
    set_current_component(component);
    const prop_values = options.props || {};
    const $$ = component.$$ = {
        fragment: null,
        ctx: null,
        // stan
        props,
        update: noop,
        not_equal,
        bound: blank_object(),
        // cykl życia
        on_mount: [],
        on_destroy: [],
        before_update: [],
        after_update: [],
        context: new Map(parent_component ? parent_component.$$.context : []),
        // reszta
        callbacks: blank_object(),
        dirty
    };
    let ready = false;
    $$.ctx = instance
        ? instance(component, prop_values, (i, ret, ...rest) => {
            const value = rest.length ? rest[0] : ret;
            if ($$.ctx && not_equal($$.ctx[i], $$.ctx[i] = value)) {
                if ($$.bound[i])
                    $$.bound[i](value);
                if (ready)
                    make_dirty(component, i);
            }
            return ret;
        })
        : [];
    $$.update();
    ready = true;
    run_all($$.before_update);
    // `false` jako specjalny przypadek przy braku komponentu DOM
    $$.fragment = create_fragment ? create_fragment($$.ctx) : false;
    if (options.target) {
        if (options.hydrate) {
            const nodes = children(options.target);
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            $$.fragment && $$.fragment.l(nodes);
            nodes.forEach(detach);
        }
        else {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            $$.fragment && $$.fragment.c();
        }
        if (options.intro)
            transition_in(component.$$.fragment);
        mount_component(component, options.target, options.anchor);
        flush();
    }
    set_current_component(parent_component);
}
class SvelteComponent {
    $destroy() {
        destroy_component(this, 1);
        this.$destroy = noop;
    }
    $on(type, callback) {
        const callbacks = (this.$$.callbacks[type] || (this.$$.callbacks[type] = []));
        callbacks.push(callback);
        return () => {
            const index = callbacks.indexOf(callback);
            if (index !== -1)
                callbacks.splice(index, 1);
        };
    }
    $set() {
        // nadpisane przez instancję, jeżeli ma własność props
    }
}

/* Homepage.svelte generated by Svelte v3.23.0 */

function create_fragment(ctx) {
	let div;
	let h1;
	let t1;
	let strong;
	let t3;
	let ul;
	let li0;
	let a0;
	let t5;
	let li1;
	let a1;
	let t7;
	let li2;
	let a2;
	let mounted;
	let dispose;

	return {
		c() {
			div = element("div");
			h1 = element("h1");
			h1.textContent = "Witaj na stronie domowej!";
			t1 = space();
			strong = element("strong");
			strong.textContent = "Oto trzy traktory:";
			t3 = space();
			ul = element("ul");
			li0 = element("li");
			a0 = element("a");
			a0.textContent = "Eicher";
			t5 = space();
			li1 = element("li");
			a1 = element("a");
			a1.textContent = "Porsche";
			t7 = space();
			li2 = element("li");
			a2 = element("a");
			a2.textContent = "Fendt";
			attr(a0, "href", "/product/eicher");
			attr(a1, "href", "/product/porsche");
			attr(a2, "href", "/product/fendt");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, h1);
			append(div, t1);
			append(div, strong);
			append(div, t3);
			append(div, ul);
			append(ul, li0);
			append(li0, a0);
			append(ul, t5);
			append(ul, li1);
			append(li1, a1);
			append(ul, t7);
			append(ul, li2);
			append(li2, a2);

			if (!mounted) {
				dispose = [
					listen(a0, "click", navigate),
					listen(a1, "click", navigate),
					listen(a2, "click", navigate)
				];

				mounted = true;
			}
		},
		p: noop,
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) detach(div);
			mounted = false;
			run_all(dispose);
		}
	};
}

function navigate(e) {
	e.preventDefault();
	const href = e.target.getAttribute("href");
	window.history.pushState(null, null, href);
}

class Homepage extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, null, create_fragment, safe_not_equal, {});
	}
}

const svelteLifecycles = singleSpaSvelte({
  component: Homepage,
  domElementGetter: () => document.getElementById("app-inspire")
});

const { bootstrap, mount, unmount } = svelteLifecycles;

export { bootstrap, mount, unmount };
