# French (fr-CA) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                               | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987ème                                       | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ème                                          | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987ème                                       | 1986-12-28T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5ème                                          | 0004-12-26T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1er                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ème                                          | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1er trim.                                     | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ème trim.                                    | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1er trimestre                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ème trimestre                                | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | T1                                            | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | T2                                            | Invalid Date             |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1er                                           | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ème                                          | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1er trim.                                     | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ème trim.                                    | Invalid Date             |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1er trimestre                                 | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2ème trimestre                                | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2ème                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7ème                                          | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | févr.                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juil.                                         | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | février                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juillet                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                             | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2ème                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7ème                                          | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | févr.                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juil.                                         | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | février                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | juillet                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                             | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1ère                                          | 2018-12-30T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 49ème                                         | 2019-12-01T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1ère                                          | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48ème                                         | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11ème                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28ème                                         | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42ème                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365ème                                        | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | lun.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven.                                          | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | lun.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven.                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | lun.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven.                                          | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | lundi                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredi                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | lu                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                            | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1er                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5ème                                          | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | lun.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven.                                          | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | lundi                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredi                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | lu                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 2ème                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6ème                                          | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | lun.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven.                                          | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | lundi                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredi                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | lu                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                            | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 2ème                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 6ème                                          | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | lun.                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ven.                                          | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | lundi                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | vendredi                                      | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | L                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | V                                             | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | lu                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | ve                                            | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | AM                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | AM                                            | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | PM                                            | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | PM                                            | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | AM                                            | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | matin                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | après-midi                                    | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | soir                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | matin                                         | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | matin                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | après-midi                                    | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | soir                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | matin                                         | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | matin                                         | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | après-midi                                    | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | soir                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | matin                                         | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | du matin                                      | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | de l’après-midi                               | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | du soir                                       | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | du matin                                      | 2019-02-11T04:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | mat.                                          | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ap.m.                                         | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | soir                                          | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | mat.                                          | 2019-02-11T04:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11ème                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11ème                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11ème                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ème                                         | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11ème                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11ème                                         | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11ème                                         | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23ème                                         | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1er                                           | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55ème                                         | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1er                                           | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55ème                                         | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 87-02-11                                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 53-05-29                                      | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 févr. 1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453                                   | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 février 1987                               | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453                                   | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | mercredi 11 février 1987                      | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | dimanche 29 mai 1453                          | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                         | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                         | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                      | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                      | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                            | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 87-02-11, 12:13                               | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 53-05-29, 23:59                               | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 févr. 1987, 12:13:14                       | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453, 23:59:59                         | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 février 1987 à 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 mai 1453 à 23:59:59 GMT+0                  | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | mercredi 11 février 1987 à 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | dimanche 29 mai 1453 à 23:59:59 GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`         |
| ------------------------ | ------------------ | ---------------------- | ------------------------- |
| 2006-01-01T00:00:00.000Z | environ 6 ans      | environ 6 ans          | dans environ 6 ans        |
| 2005-01-01T00:00:00.000Z | environ 5 ans      | environ 5 ans          | dans environ 5 ans        |
| 2004-01-01T00:00:00.000Z | environ 4 ans      | environ 4 ans          | dans environ 4 ans        |
| 2003-01-01T00:00:00.000Z | environ 3 ans      | environ 3 ans          | dans environ 3 ans        |
| 2002-01-01T00:00:00.000Z | environ 2 ans      | environ 2 ans          | dans environ 2 ans        |
| 2001-06-01T00:00:00.000Z | plus d’un an       | plus d’un an           | dans plus d’un an         |
| 2001-02-01T00:00:00.000Z | environ 1 an       | environ 1 an           | dans environ 1 an         |
| 2001-01-01T00:00:00.000Z | environ 1 an       | environ 1 an           | dans environ 1 an         |
| 2000-06-01T00:00:00.000Z | 5 mois             | 5 mois                 | dans 5 mois               |
| 2000-03-01T00:00:00.000Z | 2 mois             | 2 mois                 | dans 2 mois               |
| 2000-02-01T00:00:00.000Z | environ 1 mois     | environ 1 mois         | dans environ 1 mois       |
| 2000-01-15T00:00:00.000Z | 14 jours           | 14 jours               | dans 14 jours             |
| 2000-01-02T00:00:00.000Z | 1 jour             | 1 jour                 | dans 1 jour               |
| 2000-01-01T06:00:00.000Z | environ 6 heures   | environ 6 heures       | dans environ 6 heures     |
| 2000-01-01T01:00:00.000Z | environ 1 heure    | environ 1 heure        | dans environ 1 heure      |
| 2000-01-01T00:45:00.000Z | environ 1 heure    | environ 1 heure        | dans environ 1 heure      |
| 2000-01-01T00:30:00.000Z | 30 minutes         | 30 minutes             | dans 30 minutes           |
| 2000-01-01T00:15:00.000Z | 15 minutes         | 15 minutes             | dans 15 minutes           |
| 2000-01-01T00:01:00.000Z | 1 minute           | 1 minute               | dans 1 minute             |
| 2000-01-01T00:00:25.000Z | moins d’une minute | 30 secondes            | dans moins d’une minute   |
| 2000-01-01T00:00:15.000Z | moins d’une minute | moins de 20 secondes   | dans moins d’une minute   |
| 2000-01-01T00:00:05.000Z | moins d’une minute | moins de 10 secondes   | dans moins d’une minute   |
| 2000-01-01T00:00:00.000Z | moins d’une minute | moins de 5 secondes    | il y a moins d’une minute |
| 1999-12-31T23:59:55.000Z | moins d’une minute | moins de 10 secondes   | il y a moins d’une minute |
| 1999-12-31T23:59:45.000Z | moins d’une minute | moins de 20 secondes   | il y a moins d’une minute |
| 1999-12-31T23:59:35.000Z | moins d’une minute | 30 secondes            | il y a moins d’une minute |
| 1999-12-31T23:59:00.000Z | 1 minute           | 1 minute               | il y a 1 minute           |
| 1999-12-31T23:45:00.000Z | 15 minutes         | 15 minutes             | il y a 15 minutes         |
| 1999-12-31T23:30:00.000Z | 30 minutes         | 30 minutes             | il y a 30 minutes         |
| 1999-12-31T23:15:00.000Z | environ 1 heure    | environ 1 heure        | il y a environ 1 heure    |
| 1999-12-31T23:00:00.000Z | environ 1 heure    | environ 1 heure        | il y a environ 1 heure    |
| 1999-12-31T18:00:00.000Z | environ 6 heures   | environ 6 heures       | il y a environ 6 heures   |
| 1999-12-30T00:00:00.000Z | 2 jours            | 2 jours                | il y a 2 jours            |
| 1999-12-15T00:00:00.000Z | 17 jours           | 17 jours               | il y a 17 jours           |
| 1999-12-01T00:00:00.000Z | environ 1 mois     | environ 1 mois         | il y a environ 1 mois     |
| 1999-11-01T00:00:00.000Z | 2 mois             | 2 mois                 | il y a 2 mois             |
| 1999-06-01T00:00:00.000Z | 7 mois             | 7 mois                 | il y a 7 mois             |
| 1999-01-01T00:00:00.000Z | environ 1 an       | environ 1 an           | il y a environ 1 an       |
| 1998-12-01T00:00:00.000Z | environ 1 an       | environ 1 an           | il y a environ 1 an       |
| 1998-06-01T00:00:00.000Z | plus d’un an       | plus d’un an           | il y a plus d’un an       |
| 1998-01-01T00:00:00.000Z | environ 2 ans      | environ 2 ans          | il y a environ 2 ans      |
| 1997-01-01T00:00:00.000Z | environ 3 ans      | environ 3 ans          | il y a environ 3 ans      |
| 1996-01-01T00:00:00.000Z | environ 4 ans      | environ 4 ans          | il y a environ 4 ans      |
| 1995-01-01T00:00:00.000Z | environ 5 ans      | environ 5 ans          | il y a environ 5 ans      |
| 1994-01-01T00:00:00.000Z | environ 6 ans      | environ 6 ans          | il y a environ 6 ans      |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result      | `addSuffix: true`  | With forced unit (i.e. `hour`) |
| ------------------------ | ----------- | ------------------ | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ans       | dans 6 ans         | 52608 heures                   |
| 2005-01-01T00:00:00.000Z | 5 ans       | dans 5 ans         | 43848 heures                   |
| 2004-01-01T00:00:00.000Z | 4 ans       | dans 4 ans         | 35064 heures                   |
| 2003-01-01T00:00:00.000Z | 3 ans       | dans 3 ans         | 26304 heures                   |
| 2002-01-01T00:00:00.000Z | 2 ans       | dans 2 ans         | 17544 heures                   |
| 2001-06-01T00:00:00.000Z | 1 an        | dans 1 an          | 12408 heures                   |
| 2001-02-01T00:00:00.000Z | 1 an        | dans 1 an          | 9528 heures                    |
| 2001-01-01T00:00:00.000Z | 1 an        | dans 1 an          | 8784 heures                    |
| 2000-06-01T00:00:00.000Z | 5 mois      | dans 5 mois        | 3648 heures                    |
| 2000-03-01T00:00:00.000Z | 2 mois      | dans 2 mois        | 1440 heures                    |
| 2000-02-01T00:00:00.000Z | 1 mois      | dans 1 mois        | 744 heures                     |
| 2000-01-15T00:00:00.000Z | 14 jours    | dans 14 jours      | 336 heures                     |
| 2000-01-02T00:00:00.000Z | 1 jour      | dans 1 jour        | 24 heures                      |
| 2000-01-01T06:00:00.000Z | 6 heures    | dans 6 heures      | 6 heures                       |
| 2000-01-01T01:00:00.000Z | 1 heure     | dans 1 heure       | 1 heure                        |
| 2000-01-01T00:45:00.000Z | 45 minutes  | dans 45 minutes    | 1 heure                        |
| 2000-01-01T00:30:00.000Z | 30 minutes  | dans 30 minutes    | 1 heure                        |
| 2000-01-01T00:15:00.000Z | 15 minutes  | dans 15 minutes    | 0 heures                       |
| 2000-01-01T00:01:00.000Z | 1 minute    | dans 1 minute      | 0 heures                       |
| 2000-01-01T00:00:25.000Z | 25 secondes | dans 25 secondes   | 0 heures                       |
| 2000-01-01T00:00:15.000Z | 15 secondes | dans 15 secondes   | 0 heures                       |
| 2000-01-01T00:00:05.000Z | 5 secondes  | dans 5 secondes    | 0 heures                       |
| 2000-01-01T00:00:00.000Z | 0 secondes  | il y a 0 secondes  | 0 heures                       |
| 1999-12-31T23:59:55.000Z | 5 secondes  | il y a 5 secondes  | 0 heures                       |
| 1999-12-31T23:59:45.000Z | 15 secondes | il y a 15 secondes | 0 heures                       |
| 1999-12-31T23:59:35.000Z | 25 secondes | il y a 25 secondes | 0 heures                       |
| 1999-12-31T23:59:00.000Z | 1 minute    | il y a 1 minute    | 0 heures                       |
| 1999-12-31T23:45:00.000Z | 15 minutes  | il y a 15 minutes  | 0 heures                       |
| 1999-12-31T23:30:00.000Z | 30 minutes  | il y a 30 minutes  | 1 heure                        |
| 1999-12-31T23:15:00.000Z | 45 minutes  | il y a 45 minutes  | 1 heure                        |
| 1999-12-31T23:00:00.000Z | 1 heure     | il y a 1 heure     | 1 heure                        |
| 1999-12-31T18:00:00.000Z | 6 heures    | il y a 6 heures    | 6 heures                       |
| 1999-12-30T00:00:00.000Z | 2 jours     | il y a 2 jours     | 48 heures                      |
| 1999-12-15T00:00:00.000Z | 17 jours    | il y a 17 jours    | 408 heures                     |
| 1999-12-01T00:00:00.000Z | 1 mois      | il y a 1 mois      | 744 heures                     |
| 1999-11-01T00:00:00.000Z | 2 mois      | il y a 2 mois      | 1464 heures                    |
| 1999-06-01T00:00:00.000Z | 7 mois      | il y a 7 mois      | 5136 heures                    |
| 1999-01-01T00:00:00.000Z | 1 an        | il y a 1 an        | 8760 heures                    |
| 1998-12-01T00:00:00.000Z | 1 an        | il y a 1 an        | 9504 heures                    |
| 1998-06-01T00:00:00.000Z | 2 ans       | il y a 2 ans       | 13896 heures                   |
| 1998-01-01T00:00:00.000Z | 2 ans       | il y a 2 ans       | 17520 heures                   |
| 1997-01-01T00:00:00.000Z | 3 ans       | il y a 3 ans       | 26280 heures                   |
| 1996-01-01T00:00:00.000Z | 4 ans       | il y a 4 ans       | 35064 heures                   |
| 1995-01-01T00:00:00.000Z | 5 ans       | il y a 5 ans       | 43824 heures                   |
| 1994-01-01T00:00:00.000Z | 6 ans       | il y a 6 ans       | 52584 heures                   |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                    |
| ------------------------ | ------------------------- |
| 2000-01-10T00:00:00.000Z | 00-01-10                  |
| 2000-01-05T00:00:00.000Z | mercredi prochain à 00:00 |
| 2000-01-02T00:00:00.000Z | demain à 00:00            |
| 2000-01-01T00:00:00.000Z | aujourd’hui à 00:00       |
| 1999-12-31T00:00:00.000Z | hier à 00:00              |
| 1999-12-27T00:00:00.000Z | lundi dernier à 00:00     |
| 1999-12-21T00:00:00.000Z | 99-12-21                  |
